/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.AndDocIdSet;
import org.hibernate.search.filter.impl.FilterOptimizationHelper;

public class ChainedFilter
extends Filter {
    private static final long serialVersionUID = -6153052295766531920L;
    private final List<Filter> chainedFilters = new ArrayList<Filter>();

    public void addFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The specified filter cannot be null");
        }
        this.chainedFilters.add(filter);
    }

    public boolean removeFilter(Filter filter) {
        return this.chainedFilters.remove(filter);
    }

    public boolean isEmpty() {
        return this.chainedFilters.size() == 0;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        int size = this.chainedFilters.size();
        if (size == 0) {
            throw new AssertionFailure("No filters to chain");
        }
        if (size == 1) {
            return this.chainedFilters.get(0).getDocIdSet(reader);
        }
        List<DocIdSet> subSets = new ArrayList<DocIdSet>(size);
        for (Filter f : this.chainedFilters) {
            subSets.add(f.getDocIdSet(reader));
        }
        if ((subSets = FilterOptimizationHelper.mergeByBitAnds(subSets)).size() == 1) {
            return subSets.get(0);
        }
        return new AndDocIdSet(subSets, reader.maxDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChainedFilter");
        sb.append("{chainedFilters=").append(this.chainedFilters);
        sb.append('}');
        return sb.toString();
    }
}

