/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;

public abstract class CriteriaTools {
    public static void checkPropertyNotARelation(EnversService enversService, String entityName, String propertyName) throws AuditException {
        if (enversService.getEntitiesConfigurations().get(entityName).isRelation(propertyName)) {
            throw new AuditException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(EnversService enversService, String entityName, String propertyName) throws AuditException {
        RelationDescription relationDesc = enversService.getEntitiesConfigurations().getRelationDescription(entityName, propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new AuditException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }

    public static String determinePropertyName(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, PropertyNameGetter propertyNameGetter) {
        return CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, propertyNameGetter.get(enversService));
    }

    public static String determinePropertyName(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, String propertyName) {
        SessionFactoryImplementor sessionFactory = versionsReader.getSessionImplementor().getFactory();
        if ("$$id$$".equals(propertyName)) {
            String identifierPropertyName = sessionFactory.getMetamodel().entityPersister(entityName).getIdentifierPropertyName();
            propertyName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName() + "." + identifierPropertyName;
        } else {
            List<String> identifierPropertyNames = CriteriaTools.identifierPropertyNames(sessionFactory, entityName);
            if (identifierPropertyNames.contains(propertyName)) {
                propertyName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName() + "." + propertyName;
            } else if (propertyName != null) {
                for (String identifierPropertyName : identifierPropertyNames) {
                    if (!propertyName.startsWith(identifierPropertyName + ".")) continue;
                    propertyName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName() + propertyName.substring(identifierPropertyName.length());
                    break;
                }
            }
        }
        return propertyName;
    }

    private static List<String> identifierPropertyNames(SessionFactoryImplementor sessionFactory, String entityName) {
        String identifierPropertyName = sessionFactory.getMetamodel().entityPersister(entityName).getIdentifierPropertyName();
        if (identifierPropertyName != null) {
            return Arrays.asList(identifierPropertyName);
        }
        Type identifierType = sessionFactory.getMetamodel().entityPersister(entityName).getIdentifierType();
        if (identifierType instanceof EmbeddedComponentType) {
            EmbeddedComponentType embeddedComponentType = (EmbeddedComponentType)identifierType;
            return Arrays.asList(embeddedComponentType.getPropertyNames());
        }
        return Collections.emptyList();
    }
}

