/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import org.hibernate.envers.ModificationStore;
import org.hibernate.internal.util.compare.EqualsHelper;

public class PropertyData {
    private final String name;
    private final String beanName;
    private final String accessType;
    private final ModificationStore store;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;
    private boolean synthetic;

    public PropertyData(String newName, PropertyData propertyData) {
        this.name = newName;
        this.beanName = propertyData.beanName;
        this.accessType = propertyData.accessType;
        this.store = propertyData.store;
    }

    public PropertyData(String name, String beanName, String accessType, ModificationStore store) {
        this.name = name;
        this.beanName = beanName;
        this.accessType = accessType;
        this.store = store;
    }

    public PropertyData(String name, String beanName, String accessType, ModificationStore store, boolean usingModifiedFlag, String modifiedFlagName, boolean synthetic) {
        this(name, beanName, accessType, store);
        this.usingModifiedFlag = usingModifiedFlag;
        this.modifiedFlagName = modifiedFlagName;
        this.synthetic = synthetic;
    }

    public String getName() {
        return this.name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAccessType() {
        return this.accessType;
    }

    @Deprecated
    public ModificationStore getStore() {
        return this.store;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public String getModifiedFlagPropertyName() {
        return this.modifiedFlagName;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyData that = (PropertyData)o;
        return this.usingModifiedFlag == that.usingModifiedFlag && this.store == that.store && EqualsHelper.equals((Object)this.accessType, (Object)that.accessType) && EqualsHelper.equals((Object)this.beanName, (Object)that.beanName) && EqualsHelper.equals((Object)this.name, (Object)that.name) && EqualsHelper.equals((Object)this.synthetic, (Object)that.synthetic);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
        result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
        result = 31 * result + (this.store != null ? this.store.hashCode() : 0);
        result = 31 * result + (this.usingModifiedFlag ? 1 : 0);
        result = 31 * result + (this.synthetic ? 1 : 0);
        return result;
    }
}

