/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.BasicSQLExceptionConverter;
import org.hibernate.engine.jdbc.dialect.spi.AbstractDatabaseMetaDataDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseInfoDialectResolver;

public class StandardDatabaseMetaDataDialectResolver
extends AbstractDatabaseMetaDataDialectResolver {
    private final DatabaseInfoDialectResolver infoResolver;

    public StandardDatabaseMetaDataDialectResolver(DatabaseInfoDialectResolver infoResolver) {
        this.infoResolver = infoResolver;
    }

    @Override
    protected Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        if (this.infoResolver == null) {
            return null;
        }
        return this.infoResolver.resolve(new DatabaseInfoImpl(metaData));
    }

    public static final class DatabaseInfoImpl
    implements DatabaseInfoDialectResolver.DatabaseInfo {
        private final DatabaseMetaData databaseMetaData;

        public DatabaseInfoImpl(DatabaseMetaData databaseMetaData) {
            this.databaseMetaData = databaseMetaData;
        }

        @Override
        public String getDatabaseName() {
            try {
                return this.databaseMetaData.getDatabaseProductName();
            }
            catch (SQLException e) {
                throw BasicSQLExceptionConverter.INSTANCE.convert(e);
            }
        }

        @Override
        public int getDatabaseMajorVersion() {
            try {
                return this.databaseMetaData.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                throw BasicSQLExceptionConverter.INSTANCE.convert(e);
            }
        }

        @Override
        public int getDatabaseMinorVersion() {
            try {
                return this.databaseMetaData.getDatabaseMinorVersion();
            }
            catch (SQLException e) {
                throw BasicSQLExceptionConverter.INSTANCE.convert(e);
            }
        }
    }
}

