/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.internal;

import java.util.LinkedHashSet;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class BootstrapServiceRegistryImpl
implements ServiceRegistryImplementor,
BootstrapServiceRegistry,
ServiceBinding.ServiceLifecycleOwner {
    private static final LinkedHashSet<Integrator> NO_INTEGRATORS = new LinkedHashSet();
    private final ServiceBinding<ClassLoaderService> classLoaderServiceBinding;
    private final ServiceBinding<StrategySelector> strategySelectorBinding;
    private final ServiceBinding<IntegratorService> integratorServiceBinding;

    public BootstrapServiceRegistryImpl() {
        this(new ClassLoaderServiceImpl(), NO_INTEGRATORS);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, LinkedHashSet<Integrator> providedIntegrators) {
        this.classLoaderServiceBinding = new ServiceBinding<ClassLoaderService>(this, ClassLoaderService.class, classLoaderService);
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(classLoaderService);
        this.strategySelectorBinding = new ServiceBinding<StrategySelectorImpl>(this, StrategySelector.class, strategySelector);
        this.integratorServiceBinding = new ServiceBinding<IntegratorServiceImpl>(this, IntegratorService.class, new IntegratorServiceImpl(providedIntegrators, classLoaderService));
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, StrategySelector strategySelector, IntegratorService integratorService) {
        this.classLoaderServiceBinding = new ServiceBinding<ClassLoaderService>(this, ClassLoaderService.class, classLoaderService);
        this.strategySelectorBinding = new ServiceBinding<StrategySelector>(this, StrategySelector.class, strategySelector);
        this.integratorServiceBinding = new ServiceBinding<IntegratorService>(this, IntegratorService.class, integratorService);
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        ServiceBinding<R> binding = this.locateServiceBinding(serviceRole);
        return binding == null ? null : (R)binding.getService();
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
        if (ClassLoaderService.class.equals(serviceRole)) {
            return this.classLoaderServiceBinding;
        }
        if (StrategySelector.class.equals(serviceRole)) {
            return this.strategySelectorBinding;
        }
        if (IntegratorService.class.equals(serviceRole)) {
            return this.integratorServiceBinding;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return null;
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void configureService(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void injectDependencies(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void startService(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }

    @Override
    public <R extends Service> void stopService(ServiceBinding<R> binding) {
        throw new ServiceException("Boot-strap registry should only contain provided services");
    }
}

