/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.InvalidMappingException;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.DTDEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    public static final String ORM_1_SCHEMA_NAME = "org/hibernate/ejb/orm_1_0.xsd";
    public static final String ORM_2_SCHEMA_NAME = "org/hibernate/ejb/orm_2_0.xsd";
    private static final Logger log = LoggerFactory.getLogger(XMLHelper.class);
    public static final EntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
    private DOMReader domReader;
    private SAXReader saxReader;
    private static SAXReader orm2SaxReader;
    private static Schema orm2Schema;
    private static SAXReader orm1SaxReader;
    private static Schema orm1Schema;

    public SAXReader createSAXReader(String file, List errorsList, EntityResolver entityResolver) {
        SAXReader saxReader = this.resolveSAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(file, errorsList));
        return saxReader;
    }

    private SAXReader resolveSAXReader() {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
            this.saxReader.setMergeAdjacentText(true);
            this.saxReader.setValidation(true);
        }
        return this.saxReader;
    }

    public DOMReader createDOMReader() {
        if (this.domReader == null) {
            this.domReader = new DOMReader();
        }
        return this.domReader;
    }

    public static Element generateDom4jElement(String elementName) {
        return DocumentFactory.getInstance().createElement(elementName);
    }

    public static void dump(Element element) {
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)System.out, outformat);
            writer.write(element);
            writer.flush();
            System.out.println("");
        }
        catch (Throwable t) {
            System.out.println(element.asXML());
        }
    }

    public MetadataXml buildMetadataXml(Document xmlDocument, String originType, String originName) {
        return new MetadataXmlImpl(xmlDocument, originType, originName);
    }

    public MetadataXml readMappingDocument(EntityResolver entityResolver, MetadataXmlSource source) {
        ErrorLogger2 errorHandler = new ErrorLogger2();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler((ErrorHandler)errorHandler);
        saxReader.setMergeAdjacentText(true);
        saxReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(saxReader, "orm_2_0.xsd");
            document = saxReader.read(source.getInputSource());
            if (errorHandler.error != null) {
                throw errorHandler.error;
            }
            return this.buildMetadataXml(document, source.getOrigin().getType(), source.getOrigin().getName());
        }
        catch (Exception orm2Problem) {
            log.debug("Problem parsing XML using orm 2 xsd : {}", (Object)orm2Problem.getMessage());
            Exception failure = orm2Problem;
            errorHandler.error = null;
            if (document != null) {
                try {
                    this.setValidationFor(saxReader, "orm_1_0.xsd");
                    document = saxReader.read((Reader)new StringReader(document.asXML()));
                    if (errorHandler.error != null) {
                        throw errorHandler.error;
                    }
                    return this.buildMetadataXml(document, source.getOrigin().getType(), source.getOrigin().getName());
                }
                catch (Exception orm1Problem) {
                    log.debug("Problem parsing XML using orm 1 xsd : {}", (Object)orm1Problem.getMessage());
                    errorHandler.error = null;
                }
            }
            throw new InvalidMappingException("Unable to read XML", source.getOrigin().getType(), source.getOrigin().getName(), failure);
        }
    }

    private void setValidationFor(SAXReader saxReader, String xsd) {
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://java.sun.com/xml/ns/persistence/orm " + xsd));
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
    }

    private static SAXReader orm2SaxReader() throws IOException, SAXException {
        if (orm2SaxReader == null) {
            orm2SaxReader = XMLHelper.buildReaderWithSchema(XMLHelper.orm2Schema());
        }
        return orm2SaxReader;
    }

    private static Schema orm2Schema() throws IOException, SAXException {
        if (orm2Schema == null) {
            orm2Schema = XMLHelper.resolveLocalSchema(ORM_2_SCHEMA_NAME);
        }
        return orm2Schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema resolveLocalSchema(String schemaName) throws IOException, SAXException {
        URL url = ConfigHelper.findAsResource(schemaName);
        InputStream schemaStream = url.openStream();
        try {
            StreamSource source = new StreamSource(url.openStream());
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(source);
            return schema;
        }
        finally {
            schemaStream.close();
        }
    }

    private static SAXReader buildReaderWithSchema(Schema schema) throws SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setSchema(schema);
        try {
            SAXReader saxReader = new SAXReader(factory.newSAXParser().getXMLReader());
            saxReader.setMergeAdjacentText(true);
            saxReader.setValidation(true);
            return saxReader;
        }
        catch (ParserConfigurationException e) {
            throw new HibernateException("Unable to build SAXReader with XSD support", e);
        }
    }

    private static SAXReader orm1SaxReader() throws IOException, SAXException {
        if (orm1SaxReader == null) {
            orm1SaxReader = XMLHelper.buildReaderWithSchema(XMLHelper.orm1Schema());
        }
        return orm1SaxReader;
    }

    private static Schema orm1Schema() throws IOException, SAXException {
        if (orm1Schema == null) {
            orm1Schema = XMLHelper.resolveLocalSchema(ORM_1_SCHEMA_NAME);
        }
        return orm1Schema;
    }

    private static class ErrorLogger2
    implements ErrorHandler {
        private SAXParseException error;

        private ErrorLogger2() {
        }

        public void error(SAXParseException error) {
            log.error("Error parsing XML (" + error.getLineNumber() + ") : " + error.getMessage());
            if (this.error == null) {
                this.error = error;
            }
        }

        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        public void warning(SAXParseException warn) {
            log.error("Warning parsing XML (" + this.error.getLineNumber() + ") : " + this.error.getMessage());
        }
    }

    private static class MetadataXmlImpl
    implements MetadataXml,
    Serializable {
        private final Document xmlDocument;
        private final boolean isOrmXml;
        private final String originType;
        private final String originName;

        private MetadataXmlImpl(Document xmlDocument, String originType, String originName) {
            this.xmlDocument = xmlDocument;
            this.originType = originType;
            this.originName = originName;
            this.isOrmXml = "entity-mappings".equals(xmlDocument.getRootElement().getName());
        }

        public Document getXmlDocument() {
            return this.xmlDocument;
        }

        public boolean isOrmXml() {
            return this.isOrmXml;
        }

        public String getOriginType() {
            return this.originType;
        }

        public String getOriginName() {
            return this.originName;
        }
    }

    public static interface MetadataXml
    extends Serializable {
        public boolean isOrmXml();

        public Document getXmlDocument();

        public String getOriginType();

        public String getOriginName();
    }

    public static interface MetadataXmlSource {
        public Origin getOrigin();

        public InputSource getInputSource();

        public static interface Origin {
            public String getType();

            public String getName();
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List<SAXParseException> errors;

        private ErrorLogger(String file, List errors) {
            this.file = file;
            this.errors = errors;
        }

        public void error(SAXParseException error) {
            log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
            this.errors.add(error);
        }

        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        public void warning(SAXParseException warn) {
            log.warn("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage());
        }
    }
}

