/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContext {
    private Logger log = LoggerFactory.getLogger(XMLContext.class);
    private Default globalDefaults;
    private Map<String, Element> classOverriding = new HashMap<String, Element>();
    private Map<String, Default> defaultsOverriding = new HashMap<String, Default>();
    private List<Element> defaultElements = new ArrayList<Element>();
    private List<String> defaultEntityListeners = new ArrayList<String>();
    private boolean hasContext = false;

    public List<String> addDocument(Document doc) {
        Element unitElement;
        this.hasContext = true;
        ArrayList<String> addedClasses = new ArrayList<String>();
        Element root = doc.getRootElement();
        Element metadata = root.element("persistence-unit-metadata");
        if (metadata != null) {
            if (this.globalDefaults == null) {
                this.globalDefaults = new Default();
                this.globalDefaults.setMetadataComplete(metadata.element("xml-mapping-metadata-complete") != null ? Boolean.TRUE : null);
                Element defaultElement = metadata.element("persistence-unit-defaults");
                if (defaultElement != null) {
                    unitElement = defaultElement.element("schema");
                    this.globalDefaults.setSchema(unitElement != null ? unitElement.getTextTrim() : null);
                    unitElement = defaultElement.element("catalog");
                    this.globalDefaults.setCatalog(unitElement != null ? unitElement.getTextTrim() : null);
                    unitElement = defaultElement.element("access");
                    this.setAccess(unitElement, this.globalDefaults);
                    unitElement = defaultElement.element("cascade-persist");
                    this.globalDefaults.setCascadePersist(unitElement != null ? Boolean.TRUE : null);
                    unitElement = defaultElement.element("delimited-identifiers");
                    this.globalDefaults.setDelimitedIdentifiers(unitElement != null ? Boolean.TRUE : null);
                    this.defaultEntityListeners.addAll(this.addEntityListenerClasses(defaultElement, null, addedClasses));
                }
            } else {
                this.log.warn("Found more than one <persistence-unit-metadata>, subsequent ignored");
            }
        }
        Default entityMappingDefault = new Default();
        unitElement = root.element("package");
        String packageName = unitElement != null ? unitElement.getTextTrim() : null;
        entityMappingDefault.setPackageName(packageName);
        unitElement = root.element("schema");
        entityMappingDefault.setSchema(unitElement != null ? unitElement.getTextTrim() : null);
        unitElement = root.element("catalog");
        entityMappingDefault.setCatalog(unitElement != null ? unitElement.getTextTrim() : null);
        unitElement = root.element("access");
        this.setAccess(unitElement, entityMappingDefault);
        this.defaultElements.add(root);
        List entities = root.elements("entity");
        this.addClass(entities, packageName, entityMappingDefault, addedClasses);
        entities = root.elements("mapped-superclass");
        this.addClass(entities, packageName, entityMappingDefault, addedClasses);
        entities = root.elements("embeddable");
        this.addClass(entities, packageName, entityMappingDefault, addedClasses);
        return addedClasses;
    }

    private void setAccess(Element unitElement, Default defaultType) {
        if (unitElement != null) {
            String access = unitElement.getTextTrim();
            this.setAccess(access, defaultType);
        }
    }

    private void setAccess(String access, Default defaultType) {
        if (access != null) {
            AccessType type;
            try {
                type = AccessType.valueOf((String)access);
            }
            catch (IllegalArgumentException e) {
                throw new AnnotationException("Invalid access type " + access + " (check your xml configuration)");
            }
            defaultType.setAccess(type);
        }
    }

    private void addClass(List<Element> entities, String packageName, Default defaults, List<String> addedClasses) {
        for (Element element : entities) {
            String className = XMLContext.buildSafeClassName(element.attributeValue("class"), packageName);
            if (this.classOverriding.containsKey(className)) {
                throw new IllegalStateException("Duplicate XML entry for " + className);
            }
            addedClasses.add(className);
            this.classOverriding.put(className, element);
            Default localDefault = new Default();
            localDefault.override(defaults);
            String metadataCompleteString = element.attributeValue("metadata-complete");
            if (metadataCompleteString != null) {
                localDefault.setMetadataComplete(Boolean.parseBoolean(metadataCompleteString));
            }
            String access = element.attributeValue("access");
            this.setAccess(access, localDefault);
            this.defaultsOverriding.put(className, localDefault);
            this.log.debug("Adding XML overriding information for {}", (Object)className);
            this.addEntityListenerClasses(element, packageName, addedClasses);
        }
    }

    private List<String> addEntityListenerClasses(Element element, String packageName, List<String> addedClasses) {
        ArrayList<String> localAddedClasses = new ArrayList<String>();
        Element listeners = element.element("entity-listeners");
        if (listeners != null) {
            List elements = listeners.elements("entity-listener");
            for (Element listener : elements) {
                String listenerClassName = XMLContext.buildSafeClassName(listener.attributeValue("class"), packageName);
                if (this.classOverriding.containsKey(listenerClassName)) {
                    if ("entity-listener".equals(this.classOverriding.get(listenerClassName).getName())) {
                        this.log.info("entity-listener duplication, first event definition will be used: {}", (Object)listenerClassName);
                        continue;
                    }
                    throw new IllegalStateException("Duplicate XML entry for " + listenerClassName);
                }
                localAddedClasses.add(listenerClassName);
                this.classOverriding.put(listenerClassName, listener);
            }
        }
        this.log.debug("Adding XML overriding information for listener: {}", (Object)listeners);
        addedClasses.addAll(localAddedClasses);
        return localAddedClasses;
    }

    public static String buildSafeClassName(String className, String defaultPackageName) {
        if (className.indexOf(46) < 0 && StringHelper.isNotEmpty((String)defaultPackageName)) {
            className = StringHelper.qualify((String)defaultPackageName, (String)className);
        }
        return className;
    }

    public static String buildSafeClassName(String className, Default defaults) {
        return XMLContext.buildSafeClassName(className, defaults.getPackageName());
    }

    public Default getDefault(String className) {
        Default xmlDefault = new Default();
        xmlDefault.override(this.globalDefaults);
        if (className != null) {
            Default entityMappingOverriding = this.defaultsOverriding.get(className);
            xmlDefault.override(entityMappingOverriding);
        }
        return xmlDefault;
    }

    public Element getXMLTree(String className) {
        return this.classOverriding.get(className);
    }

    public List<Element> getAllDocuments() {
        return this.defaultElements;
    }

    public boolean hasContext() {
        return this.hasContext;
    }

    public List<String> getDefaultEntityListeners() {
        return this.defaultEntityListeners;
    }

    public static class Default {
        private AccessType access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;
        private Boolean delimitedIdentifier;

        public AccessType getAccess() {
            return this.access;
        }

        protected void setAccess(AccessType access) {
            this.access = access;
        }

        public String getCatalog() {
            return this.catalog;
        }

        protected void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getPackageName() {
            return this.packageName;
        }

        protected void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getSchema() {
            return this.schema;
        }

        protected void setSchema(String schema) {
            this.schema = schema;
        }

        public Boolean getMetadataComplete() {
            return this.metadataComplete;
        }

        public boolean canUseJavaAnnotations() {
            return this.metadataComplete == null || this.metadataComplete == false;
        }

        protected void setMetadataComplete(Boolean metadataComplete) {
            this.metadataComplete = metadataComplete;
        }

        public Boolean getCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean cascadePersist) {
            this.cascadePersist = cascadePersist;
        }

        public void override(Default globalDefault) {
            if (globalDefault != null) {
                if (globalDefault.getAccess() != null) {
                    this.access = globalDefault.getAccess();
                }
                if (globalDefault.getPackageName() != null) {
                    this.packageName = globalDefault.getPackageName();
                }
                if (globalDefault.getSchema() != null) {
                    this.schema = globalDefault.getSchema();
                }
                if (globalDefault.getCatalog() != null) {
                    this.catalog = globalDefault.getCatalog();
                }
                if (globalDefault.getDelimitedIdentifier() != null) {
                    this.delimitedIdentifier = globalDefault.getDelimitedIdentifier();
                }
                if (globalDefault.getMetadataComplete() != null) {
                    this.metadataComplete = globalDefault.getMetadataComplete();
                }
                if (globalDefault.getCascadePersist() != null) {
                    this.cascadePersist = globalDefault.getCascadePersist();
                }
            }
        }

        public void setDelimitedIdentifiers(Boolean delimitedIdentifier) {
            this.delimitedIdentifier = delimitedIdentifier;
        }

        public Boolean getDelimitedIdentifier() {
            return this.delimitedIdentifier;
        }
    }
}

