/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.impl.FutureImpl;

public class SafeFutureImpl<R>
implements FutureImpl<R> {
    private final Object chSync = new Object();
    private Set<CompletionHandler<R>> completionHandlers;
    private final Sync sync = new Sync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCompletionHandler(CompletionHandler<R> completionHandler) {
        if (this.isDone()) {
            this.notifyCompletionHandler(completionHandler);
        } else {
            Object object = this.chSync;
            synchronized (object) {
                if (!this.isDone()) {
                    if (this.completionHandlers == null) {
                        this.completionHandlers = new HashSet<CompletionHandler<R>>(2);
                    }
                    this.completionHandlers.add(completionHandler);
                    return;
                }
            }
            this.notifyCompletionHandler(completionHandler);
        }
    }

    public static <R> SafeFutureImpl<R> create() {
        return new SafeFutureImpl<R>();
    }

    @Override
    public void result(R result) {
        this.sync.innerSet(result);
    }

    @Override
    public void failure(Throwable failure) {
        this.sync.innerSetException(failure);
    }

    @Override
    public void markForRecycle(boolean recycleResult) {
    }

    @Override
    public void recycle(boolean recycleResult) {
    }

    @Override
    public void recycle() {
    }

    @Override
    public R getResult() {
        if (this.isDone()) {
            try {
                return this.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected void onComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompletionHandlers() {
        Set<CompletionHandler<R>> localSet;
        assert (this.isDone());
        Object object = this.chSync;
        synchronized (object) {
            if (this.completionHandlers == null) {
                return;
            }
            localSet = this.completionHandlers;
            this.completionHandlers = null;
        }
        boolean isCancelled = this.isCancelled();
        Object result = this.sync.result;
        Throwable error = this.sync.exception;
        Iterator<CompletionHandler<R>> it = localSet.iterator();
        while (it.hasNext()) {
            CompletionHandler<R> completionHandler = it.next();
            it.remove();
            try {
                if (isCancelled) {
                    completionHandler.cancelled();
                    continue;
                }
                if (error != null) {
                    completionHandler.failed(error);
                    continue;
                }
                completionHandler.completed(result);
            }
            catch (Exception ignored) {}
        }
    }

    private void notifyCompletionHandler(CompletionHandler<R> completionHandler) {
        if (this.isCancelled()) {
            completionHandler.cancelled();
        } else {
            try {
                R result = this.get();
                try {
                    completionHandler.completed(result);
                }
                catch (Exception exception) {}
            }
            catch (ExecutionException e) {
                completionHandler.failed(e.getCause());
            }
            catch (Exception e) {
                completionHandler.failed(e);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.sync.ranOrCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    protected void done() {
        this.notifyCompletionHandlers();
        this.onComplete();
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -7828117401763700385L;
        private static final int READY = 0;
        private static final int RESULT = 1;
        private static final int RAN = 2;
        private static final int CANCELLED = 3;
        private R result;
        private Throwable exception;

        private Sync() {
        }

        private boolean ranOrCancelled() {
            return (this.getState() & 3) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.ranOrCancelled() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 3;
        }

        R innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 3) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        R innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 3) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(R v) {
            if (this.compareAndSetState(0, 1)) {
                this.result = v;
                this.setState(2);
                this.releaseShared(0);
                SafeFutureImpl.this.done();
            }
        }

        void innerSetException(Throwable t) {
            if (this.compareAndSetState(0, 1)) {
                this.exception = t;
                this.setState(2);
                this.releaseShared(0);
                SafeFutureImpl.this.done();
            }
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            if (this.compareAndSetState(0, 3)) {
                this.releaseShared(0);
                SafeFutureImpl.this.done();
                return true;
            }
            return false;
        }
    }
}

