/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestResolution
extends TestingPanel {
    public TestResolution(String[] args) throws Exception {
        super(args);
        this.setName("Resolution");
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        double w = dim.width / 3;
        double h = dim.height / 5;
        double s = 1.0E-7;
        for (int i = 0; i < 15; ++i) {
            VectorGraphics vgs = (VectorGraphics)vg.create();
            if (i < 5) {
                vgs.translate(0.0, (double)i * h);
            } else if (i < 10) {
                vgs.translate(w, (double)(i - 5) * h);
            } else {
                vgs.translate(2.0 * w, (double)(i - 10) * h);
            }
            vgs.translate(w / 2.0, h / 2.0);
            double sc = 0.5 * Math.min(w, h) / 2.0;
            vgs.scale(sc, sc);
            vgs.scale(1.0 / s, 1.0 / s);
            vgs.setStroke((Stroke)new BasicStroke((float)(0.5 * s), 1, 1));
            vgs.setColor(Color.black);
            vgs.draw((Shape)new Ellipse2D.Double(-1.0 * s, -1.0 * s, 2.0 * s, 2.0 * s));
            vgs.dispose();
            s *= 10.0;
        }
    }

    public static void main(String[] args) throws Exception {
        new TestResolution(args).runTest();
    }
}

