/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.test.ExecutionListenerHelper;
import org.flywaydb.test.annotation.FlywayTest;
import org.flywaydb.test.annotation.FlywayTests;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class FlywayTestExecutionListener
extends AbstractTestExecutionListener
implements TestExecutionListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private int order = 4000;

    protected Log getLogger() {
        return this.logger;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        this.handleFlywayTestAnnotationForClass(testContext, testClass);
        Class beforeClassClass = this.getClassOrNullForName("org.junit.BeforeClass");
        Class beforeAllClass = this.getClassOrNullForName("org.junit.jupiter.api.BeforeAll");
        Class beforeClassTestNgClass = this.getClassOrNullForName("org.testng.annotations.BeforeClass");
        this.handleFlywayTestWithTestAnnotation(testContext, testClass, beforeClassClass, beforeAllClass, beforeClassTestNgClass);
    }

    private void handleFlywayTestAnnotationForClass(TestContext testContext, Class<?> testClass) {
        FlywayTests containerAnnotation = (FlywayTests)AnnotationUtils.getAnnotation(testClass, FlywayTests.class);
        if (containerAnnotation != null) {
            FlywayTest[] annotations;
            for (FlywayTest annotation : annotations = containerAnnotation.value()) {
                this.dbResetWithAnnotation(testContext, annotation);
            }
        } else {
            FlywayTest annotation = (FlywayTest)AnnotationUtils.getAnnotation(testClass, FlywayTest.class);
            if (annotation != null) {
                this.dbResetWithAnnotation(testContext, annotation);
            }
        }
    }

    public void beforeTestExecution(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        Class beforeMethodTestNgClass = this.getClassOrNullForName("org.testng.annotations.BeforeMethod");
        this.handleFlywayTestWithTestAnnotation(testContext, testClass, null, null, beforeMethodTestNgClass);
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        Class beforeMethodClass = this.getClassOrNullForName("org.junit.Before");
        Class beforeEachMethodClass = this.getClassOrNullForName("org.junit.jupiter.api.BeforeEach");
        this.handleFlywayTestWithTestAnnotation(testContext, testClass, beforeMethodClass, beforeEachMethodClass, null);
    }

    private void handleFlywayTestWithTestAnnotation(TestContext testContext, Class testClass, Class junit4TestAnnotationClass, Class junit5TestAnnotationClass, Class testNgAnnotationClass) {
        for (Class currentTestClass = testClass; currentTestClass != Object.class; currentTestClass = currentTestClass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(currentTestClass.getDeclaredMethods()));
            for (Method method : allMethods) {
                if (!this.isMethodAnnotatedWithAtLeastOne(method, junit4TestAnnotationClass, junit5TestAnnotationClass, testNgAnnotationClass) || !this.isMethodAnnotatedWithAtLeastOne(method, FlywayTest.class, FlywayTests.class, null)) continue;
                this.getLogger().debug((Object)("Method " + method.getName() + " using flyway annotation."));
                if (!this.handleFlywayTestAnnotationForMethod(testContext, method)) continue;
                return;
            }
        }
    }

    private boolean isMethodAnnotatedWithAtLeastOne(Method method, Class firtsAnnotationToCheck, Class secondAnnotationToCheck, Class testNgAnnotationToCheck) {
        return firtsAnnotationToCheck != null && method.isAnnotationPresent(firtsAnnotationToCheck) || secondAnnotationToCheck != null && method.isAnnotationPresent(secondAnnotationToCheck) || testNgAnnotationToCheck != null && method.isAnnotationPresent(testNgAnnotationToCheck);
    }

    private Class getClassOrNullForName(String classname) {
        Class<?> before = null;
        try {
            before = ((Object)((Object)this)).getClass().getClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException ignored) {
            this.getLogger().debug((Object)String.format("No class %s is present.", classname));
        }
        return before;
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        this.handleFlywayTestAnnotationForMethod(testContext, testMethod);
    }

    private boolean handleFlywayTestAnnotationForMethod(TestContext testContext, Method method) {
        boolean result = false;
        FlywayTests containerAnnotation = (FlywayTests)AnnotationUtils.getAnnotation((Method)method, FlywayTests.class);
        if (containerAnnotation != null) {
            FlywayTest[] annotations;
            for (FlywayTest annotation : annotations = containerAnnotation.value()) {
                this.dbResetWithAnnotation(testContext, annotation);
                result = true;
            }
        } else {
            FlywayTest annotation = (FlywayTest)AnnotationUtils.getAnnotation((Method)method, FlywayTest.class);
            if (annotation != null) {
                this.dbResetWithAnnotation(testContext, annotation);
                result = true;
            }
        }
        return result;
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    private void dbResetWithAnnotation(TestContext testContext, FlywayTest annotation) {
        if (annotation != null) {
            Flyway flyWay = null;
            ApplicationContext appContext = testContext.getApplicationContext();
            if (appContext != null) {
                flyWay = this.getBean(appContext, Flyway.class, annotation.flywayName());
                if (flyWay != null) {
                    String executionInfo = "";
                    if (this.logger.isInfoEnabled()) {
                        executionInfo = ExecutionListenerHelper.getExecutionInformation(testContext);
                        this.logger.info((Object)("---> Start reset database for  '" + executionInfo + "'."));
                    }
                    if (annotation.invokeCleanDB()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("******** Clean database for  '" + executionInfo + "'."));
                        }
                        flyWay.clean();
                    }
                    if (annotation.invokeBaselineDB()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("******** Baseline database  for  '" + executionInfo + "'."));
                        }
                        flyWay.baseline();
                    }
                    if (annotation.invokeMigrateDB()) {
                        String[] locations = annotation.locationsForMigrate();
                        if (locations == null || locations.length == 0) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("******** Default migrate database for  '" + executionInfo + "'."));
                            }
                            flyWay.migrate();
                        } else {
                            this.locationsMigrationHandling(annotation, flyWay, executionInfo);
                        }
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("<--- Finished reset database  for  '" + executionInfo + "'."));
                    }
                    return;
                }
                throw new IllegalArgumentException("Annotation " + annotation.getClass() + " was set, but no Flyway configuration was given.");
            }
            throw new IllegalArgumentException("Annotation " + annotation.getClass() + " was set, but no configuration was given.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"dbResetWithAnnotation is called without a flyway test annotation.");
        }
    }

    private void locationsMigrationHandling(FlywayTest annotation, Flyway flyWay, String executionInfo) {
        String[] locations = annotation.locationsForMigrate();
        String[] oldLocations = this.convertLocationToString(flyWay);
        boolean override = annotation.overrideLocations();
        String[] useLocations = null;
        if (override) {
            useLocations = locations;
        } else {
            useLocations = Arrays.copyOf(oldLocations, oldLocations.length + locations.length);
            System.arraycopy(locations, 0, useLocations, oldLocations.length, locations.length);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("******** Start migration from locations directories '%s'  for  '%s'.", Arrays.asList(useLocations), executionInfo));
        }
        FluentConfiguration fluentConfiguration = new FluentConfiguration();
        fluentConfiguration.configuration(flyWay.getConfiguration()).locations(useLocations).load().migrate();
    }

    private String[] convertLocationToString(Flyway flyWay) {
        Location[] locations = flyWay.getConfiguration().getLocations();
        String[] stringLocations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            stringLocations[i] = locations[i].getDescriptor();
        }
        return stringLocations;
    }

    private Flyway getBean(ApplicationContext context, Class<?> classType, String idName) {
        Flyway result = null;
        String[] names = context.getBeanNamesForType(classType);
        if (names != null && names.length > 0) {
            result = idName == null || idName.trim().isEmpty() ? (Flyway)context.getBean(names[0]) : (Flyway)context.getBean(idName);
        }
        return result;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

