/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

abstract class SWTFocusCellManager {
    private CellNavigationStrategy navigationStrategy;
    private ColumnViewer viewer;
    private ViewerCell focusCell;
    private FocusCellHighlighter cellHighlighter;
    private DisposeListener itemDeletionListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            SWTFocusCellManager.this.setFocusCell(null);
        }
    };

    public SWTFocusCellManager(ColumnViewer viewer, FocusCellHighlighter focusDrawingDelegate, CellNavigationStrategy navigationDelegate) {
        this.viewer = viewer;
        this.cellHighlighter = focusDrawingDelegate;
        this.navigationStrategy = navigationDelegate;
        this.hookListener(viewer);
    }

    void init() {
        this.cellHighlighter.init();
        this.navigationStrategy.init();
    }

    private void handleMouseDown(Event event) {
        ViewerCell cell = this.viewer.getCell(new Point(event.x, event.y));
        if (cell != null && !cell.equals(this.focusCell)) {
            this.setFocusCell(cell);
        }
    }

    private void handleKeyDown(Event event) {
        ViewerCell tmp = null;
        if (this.navigationStrategy.isCollapseEvent(this.viewer, this.focusCell, event)) {
            this.navigationStrategy.collapse(this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isExpandEvent(this.viewer, this.focusCell, event)) {
            this.navigationStrategy.expand(this.viewer, this.focusCell, event);
        } else if (this.navigationStrategy.isNavigationEvent(this.viewer, event) && (tmp = this.navigationStrategy.findSelectedCell(this.viewer, this.focusCell, event)) != null && !tmp.equals(this.focusCell)) {
            this.setFocusCell(tmp);
        }
        if (this.navigationStrategy.shouldCancelEvent(this.viewer, event)) {
            event.doit = false;
        }
    }

    private void handleSelection(Event event) {
        if (this.focusCell != null && this.focusCell.getItem() != event.item && event.item != null) {
            ViewerRow row = this.viewer.getViewerRowFromItem(event.item);
            Assert.isNotNull((Object)row, (String)"Internal Structure invalid. Row item has no row ViewerRow assigned");
            ViewerCell tmp = row.getCell(this.focusCell.getColumnIndex());
            if (!this.focusCell.equals(tmp)) {
                this.setFocusCell(tmp);
            }
        }
    }

    private void handleFocusIn(Event event) {
        if (this.focusCell == null) {
            this.setFocusCell(this.getInitialFocusCell());
        }
    }

    abstract ViewerCell getInitialFocusCell();

    private void hookListener(ColumnViewer viewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        SWTFocusCellManager.this.handleMouseDown(event);
                        break;
                    }
                    case 1: {
                        SWTFocusCellManager.this.handleKeyDown(event);
                        break;
                    }
                    case 13: {
                        SWTFocusCellManager.this.handleSelection(event);
                        break;
                    }
                    case 15: {
                        SWTFocusCellManager.this.handleFocusIn(event);
                    }
                }
            }
        };
        viewer.getControl().addListener(3, listener);
        viewer.getControl().addListener(1, listener);
        viewer.getControl().addListener(13, listener);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.selection.isEmpty()) {
                    SWTFocusCellManager.this.setFocusCell(null);
                }
            }
        });
        viewer.getControl().addListener(15, listener);
    }

    public ViewerCell getFocusCell() {
        return this.focusCell;
    }

    void setFocusCell(ViewerCell focusCell) {
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().removeDisposeListener(this.itemDeletionListener);
        }
        this.focusCell = focusCell;
        if (this.focusCell != null && !this.focusCell.getItem().isDisposed()) {
            this.focusCell.getItem().addDisposeListener(this.itemDeletionListener);
        }
        this.cellHighlighter.focusCellChanged(focusCell);
    }

    ColumnViewer getViewer() {
        return this.viewer;
    }
}

