/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.io.Reader;
import org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.eclipse.jetty.websocket.jsr356.annotations.IJsrParamId;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrParamIdOnMessage;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;

public class JsrParamIdText
extends JsrParamIdOnMessage
implements IJsrParamId {
    public static final IJsrParamId INSTANCE = new JsrParamIdText();

    private boolean isMessageRoleAssigned(JsrCallable callable) {
        if (callable instanceof OnMessageCallable) {
            OnMessageCallable onmessage = (OnMessageCallable)callable;
            return onmessage.isMessageRoleAssigned();
        }
        return false;
    }

    @Override
    public boolean process(Param param, JsrCallable callable) throws InvalidSignatureException {
        if (super.process(param, callable)) {
            return true;
        }
        if (param.type.isAssignableFrom(String.class)) {
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(String.class);
            return true;
        }
        if (param.type.isAssignableFrom(Boolean.class)) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Boolean.class);
            return true;
        }
        if (param.type.isAssignableFrom(Byte.class) || param.type == Byte.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Byte.class);
            return true;
        }
        if (param.type.isAssignableFrom(Character.class) || param.type == Character.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Character.class);
            return true;
        }
        if (param.type.isAssignableFrom(Double.class) || param.type == Double.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Double.class);
            return true;
        }
        if (param.type.isAssignableFrom(Float.class) || param.type == Float.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Float.class);
            return true;
        }
        if (param.type.isAssignableFrom(Integer.class) || param.type == Integer.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Integer.class);
            return true;
        }
        if (param.type.isAssignableFrom(Long.class) || param.type == Long.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Long.class);
            return true;
        }
        if (param.type.isAssignableFrom(Short.class) || param.type == Short.TYPE) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT);
            callable.setDecodingType(Short.class);
            return true;
        }
        if (param.type.isAssignableFrom(Reader.class)) {
            this.assertPartialMessageSupportDisabled(param, callable);
            param.bind(Param.Role.MESSAGE_TEXT_STREAM);
            callable.setDecodingType(Reader.class);
            return true;
        }
        if (param.type == Boolean.TYPE) {
            if (this.isMessageRoleAssigned(callable)) {
                param.bind(Param.Role.MESSAGE_PARTIAL_FLAG);
            } else {
                param.bind(Param.Role.MESSAGE_TEXT);
                callable.setDecodingType(Boolean.class);
            }
            return true;
        }
        return false;
    }
}

