/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;

public class BlockingCallback
implements Callback<Integer> {
    private static Throwable COMPLETED = new Throwable();
    private final AtomicBoolean _done = new AtomicBoolean(false);
    private final Semaphore _semaphone = new Semaphore(0);
    private Throwable _cause;
    private volatile int _phase;

    @Override
    public void completed(Integer phase) {
        if (phase == null) {
            throw new IllegalStateException("Context must be getPhase()");
        }
        if (this._phase == phase && this._done.compareAndSet(false, true)) {
            ++this._phase;
            this._cause = COMPLETED;
            this._semaphone.release();
        }
    }

    @Override
    public void failed(Integer phase, Throwable cause) {
        if (phase == null) {
            throw new IllegalStateException("Context must be getPhase()");
        }
        if (this._phase == phase && this._done.compareAndSet(false, true)) {
            ++this._phase;
            this._cause = cause;
            this._semaphone.release();
        }
    }

    public Integer getPhase() {
        return new Integer(this._phase);
    }

    public void block() throws InterruptedException, IOException, TimeoutException {
        this._semaphone.acquire();
        try {
            if (this._cause == COMPLETED) {
                return;
            }
            if (this._cause instanceof IOException) {
                throw (IOException)this._cause;
            }
            if (this._cause instanceof CancellationException) {
                throw (CancellationException)this._cause;
            }
            if (this._cause instanceof TimeoutException) {
                throw (TimeoutException)this._cause;
            }
            throw new IOException(this._cause);
        }
        finally {
            this._done.set(false);
            this._cause = null;
        }
    }

    public String toString() {
        return String.format("%s@%x{%b,%b}", BlockingCallback.class.getSimpleName(), this.hashCode(), this._done.get(), this._cause == COMPLETED);
    }
}

