/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.ByteBufferHttpInput;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Runnable,
HttpTransport {
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = "org.eclipse.jetty.server.HttpConnection.UPGRADE";
    private static final boolean REQUEST_BUFFER_DIRECT = false;
    private static final boolean HEADER_BUFFER_DIRECT = true;
    private static final boolean CHUNK_BUFFER_DIRECT = false;
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final HttpConfiguration _config;
    private final Connector _connector;
    private final ByteBufferPool _bufferPool;
    private final HttpGenerator _generator;
    private final HttpChannelOverHttp _channel;
    private final HttpParser _parser;
    private volatile ByteBuffer _requestBuffer = null;
    private volatile ByteBuffer _chunk = null;
    private BlockingCallback _readBlocker = new BlockingCallback();
    private BlockingCallback _writeBlocker = new BlockingCallback();

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public HttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
        super(endPoint, connector.getExecutor(), true);
        this._config = config;
        this._connector = connector;
        this._bufferPool = this._connector.getByteBufferPool();
        this._generator = new HttpGenerator();
        this._generator.setSendServerVersion(this._config.getSendServerVersion());
        this._channel = new HttpChannelOverHttp(connector, config, endPoint, this, new Input());
        this._parser = this.newHttpParser();
        LOG.debug("New HTTP Connection {}", new Object[]{this});
    }

    protected HttpParser newHttpParser() {
        return new HttpParser(this.newRequestHandler(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    protected HttpParser.RequestHandler<ByteBuffer> newRequestHandler() {
        return this._channel;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public void reset() {
        if (this._channel.isExpecting100Continue()) {
            this._parser.reset();
            this._parser.close();
        } else if (this._generator.isPersistent()) {
            this._parser.reset();
        } else {
            this._parser.close();
        }
        this._generator.reset();
        this._channel.reset();
        this.releaseRequestBuffer();
        if (this._chunk != null) {
            this._bufferPool.release(this._chunk);
            this._chunk = null;
        }
    }

    public int getMessagesIn() {
        return this.getHttpChannel().getRequests();
    }

    public int getMessagesOut() {
        return this.getHttpChannel().getRequests();
    }

    public String toString() {
        return String.format("%s,g=%s,p=%s", super.toString(), this._generator, this._parser);
    }

    private void releaseRequestBuffer() {
        if (this._requestBuffer != null && !this._requestBuffer.hasRemaining()) {
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            this._bufferPool.release(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFillable() {
        LOG.debug("{} onFillable {}", new Object[]{this, this._channel.getState()});
        HttpConnection.setCurrentConnection(this);
        try {
            while (true) {
                boolean call_channel;
                if (!(call_channel = this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer))) {
                    int filled;
                    if (!BufferUtil.isEmpty((ByteBuffer)this._requestBuffer)) {
                        LOG.warn("Unexpected state: " + this + " " + this._channel + " " + this._channel.getRequest(), new Object[0]);
                        if (this._channel.getState().isSuspended()) return;
                        this.getEndPoint().close();
                        return;
                    }
                    if (this._requestBuffer == null) {
                        this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), false);
                    }
                    if ((filled = this.getEndPoint().fill(this._requestBuffer)) == 0) {
                        filled = this.getEndPoint().fill(this._requestBuffer);
                    }
                    LOG.debug("{} filled {}", new Object[]{this, filled});
                    if (filled == 0) {
                        this.releaseRequestBuffer();
                        this.fillInterested();
                        return;
                    }
                    if (filled < 0) {
                        this._parser.shutdownInput();
                        if (this.getEndPoint().isOutputShutdown()) {
                            this.getEndPoint().close();
                        } else {
                            this.getEndPoint().shutdownOutput();
                        }
                        this.releaseRequestBuffer();
                        return;
                    }
                } else {
                    while (this._parser.inContentState() && this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer)) {
                    }
                    boolean handle = this._channel.handle();
                    if (!handle) return;
                    if (this.getEndPoint().getConnection() != this) {
                        return;
                    }
                }
                continue;
                break;
            }
        }
        catch (EofException e) {
            LOG.debug((Throwable)e);
            return;
        }
        catch (Exception e) {
            if (this._parser.isIdle()) {
                LOG.debug((Throwable)e);
            } else {
                LOG.warn(this.toString(), (Throwable)e);
            }
            this.close();
            return;
        }
        finally {
            HttpConnection.setCurrentConnection(null);
        }
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void run() {
        this.onFillable();
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws IOException {
        if (this._channel.isExpecting100Continue()) {
            this._generator.setPersistent(false);
        }
        ByteBuffer header = null;
        ByteBuffer chunk = null;
        block8: while (true) {
            HttpGenerator.Result result = this._generator.generateResponse(info, header, chunk, content, lastContent);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} generate: {} ({},{},{})@{}", new Object[]{this, result, BufferUtil.toSummaryString((ByteBuffer)header), BufferUtil.toSummaryString((ByteBuffer)content), lastContent, this._generator.getState()});
            }
            switch (result) {
                case NEED_HEADER: {
                    if (lastContent && content != null && BufferUtil.space((ByteBuffer)content) > this._config.getResponseHeaderSize() && content.hasArray()) {
                        int p = content.position();
                        int l = content.limit();
                        content.position(l);
                        content.limit(l + this._config.getResponseHeaderSize());
                        header = content.slice();
                        header.limit(0);
                        content.position(p);
                        content.limit(l);
                        continue block8;
                    }
                    header = this._bufferPool.acquire(this._config.getResponseHeaderSize(), true);
                    continue block8;
                }
                case NEED_CHUNK: {
                    chunk = this._chunk;
                    if (chunk != null) continue block8;
                    chunk = this._chunk = this._bufferPool.acquire(12, false);
                    continue block8;
                }
                case FLUSH: {
                    if (this._channel.getRequest().isHead()) {
                        BufferUtil.clear((ByteBuffer)chunk);
                        BufferUtil.clear((ByteBuffer)content);
                    }
                    if (BufferUtil.hasContent(header)) {
                        if (BufferUtil.hasContent((ByteBuffer)content)) {
                            this.blockingWrite(header, content);
                            continue block8;
                        }
                        this.blockingWrite(header);
                        continue block8;
                    }
                    if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                        if (BufferUtil.hasContent((ByteBuffer)content)) {
                            this.blockingWrite(chunk, content);
                            continue block8;
                        }
                        this.blockingWrite(chunk);
                        continue block8;
                    }
                    if (!BufferUtil.hasContent((ByteBuffer)content)) continue block8;
                    this.blockingWrite(content);
                    continue block8;
                }
                case SHUTDOWN_OUT: {
                    this.getEndPoint().shutdownOutput();
                    continue block8;
                }
                case DONE: {
                    if (!(header == null || lastContent && content != null && content.hasArray() && header.hasArray() && content.array() == header.array())) {
                        this._bufferPool.release(header);
                    }
                    if (chunk == null) break block8;
                    this._bufferPool.release(chunk);
                    break block8;
                }
                case CONTINUE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("generateResponse=" + result);
                }
            }
        }
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        try {
            this.send(info, content, lastContent);
            callback.succeeded();
        }
        catch (IOException e) {
            callback.failed((Throwable)e);
        }
    }

    private void blockingWrite(ByteBuffer ... bytes) throws IOException {
        try {
            this.getEndPoint().write((Callback)this._writeBlocker, bytes);
            this._writeBlocker.block();
        }
        catch (InterruptedException x) {
            throw (IOException)new InterruptedIOException().initCause(x);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
        catch (ClosedChannelException e) {
            throw new EofException((Throwable)e);
        }
    }

    @Override
    public void completed() {
        Connection connection;
        if (this._parser.isInContent() && this._generator.isPersistent() && !this._channel.isExpecting100Continue()) {
            this._channel.getRequest().getHttpInput().consumeAll();
        }
        if (this._channel.getResponse().getStatus() == 101 && (connection = (Connection)this._channel.getRequest().getAttribute(UPGRADE_CONNECTION_ATTRIBUTE)) != null) {
            LOG.debug("Upgrade from {} to {}", new Object[]{this, connection});
            this.onClose();
            this.getEndPoint().setConnection(connection);
            connection.onOpen();
            this.reset();
            return;
        }
        this.reset();
        if (HttpConnection.getCurrentConnection() == null && this._parser.isStart()) {
            if (this._requestBuffer == null) {
                this.fillInterested();
            } else if (this.getConnector().isStarted()) {
                LOG.debug("{} pipelined", new Object[]{this});
                try {
                    this.getExecutor().execute(this);
                }
                catch (RejectedExecutionException e) {
                    if (this.getConnector().isStarted()) {
                        LOG.warn((Throwable)e);
                    } else {
                        LOG.ignore((Throwable)e);
                    }
                    this.getEndPoint().close();
                }
            } else {
                this.getEndPoint().close();
            }
        }
    }

    public ByteBuffer getRequestBuffer() {
        return this._requestBuffer;
    }

    private class HttpChannelOverHttp
    extends HttpChannel<ByteBuffer> {
        public HttpChannelOverHttp(Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport, HttpInput<ByteBuffer> input) {
            super(connector, config, endPoint, transport, input);
        }

        @Override
        public void badMessage(int status, String reason) {
            HttpConnection.this._generator.setPersistent(false);
            super.badMessage(status, reason);
        }

        @Override
        public boolean headerComplete() {
            boolean persistent;
            HttpVersion version = this.getHttpVersion();
            switch (version) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (!persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                    break;
                }
                case HTTP_1_1: {
                    boolean bl = persistent = !this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!persistent) {
                HttpConnection.this._generator.setPersistent(false);
            }
            return super.headerComplete();
        }

        @Override
        protected void handleException(Throwable x) {
            HttpConnection.this._generator.setPersistent(false);
            super.handleException(x);
        }
    }

    private class Input
    extends ByteBufferHttpInput {
        private Input() {
        }

        @Override
        protected void blockForContent() throws IOException {
            try {
                while (true) {
                    boolean event = HttpConnection.this._parser.parseNext(HttpConnection.this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : HttpConnection.this._requestBuffer);
                    while (event && BufferUtil.hasContent((ByteBuffer)HttpConnection.this._requestBuffer) && HttpConnection.this._parser.inContentState()) {
                        HttpConnection.this._parser.parseNext(HttpConnection.this._requestBuffer);
                    }
                    if (event) {
                        return;
                    }
                    if (!BufferUtil.isEmpty((ByteBuffer)HttpConnection.this._requestBuffer)) continue;
                    if (HttpConnection.this.getEndPoint().isInputShutdown()) {
                        HttpConnection.this._parser.shutdownInput();
                        this.shutdown();
                        return;
                    }
                    HttpConnection.this.block(HttpConnection.this._readBlocker);
                    LOG.debug("{} block readable on {}", new Object[]{this, HttpConnection.this._readBlocker});
                    HttpConnection.this._readBlocker.block();
                    if (HttpConnection.this._requestBuffer == null) {
                        long content_length = HttpConnection.this._channel.getRequest().getContentLength();
                        int size = HttpConnection.this.getInputBufferSize();
                        if ((long)size < content_length) {
                            size *= 4;
                        }
                        HttpConnection.this._requestBuffer = HttpConnection.this._bufferPool.acquire(size, false);
                    }
                    int filled = HttpConnection.this.getEndPoint().fill(HttpConnection.this._requestBuffer);
                    LOG.debug("{} block filled {}", new Object[]{this, filled});
                    if (filled < 0) break;
                }
                HttpConnection.this._parser.shutdownInput();
                return;
            }
            catch (TimeoutException e) {
                throw new EofException((Throwable)e);
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException(HttpConnection.this.getEndPoint().toString()){
                    {
                        super(x0);
                        this.initCause(x);
                    }
                };
            }
        }

        @Override
        protected void onContentQueued(ByteBuffer ref) {
        }

        @Override
        protected void onAllContentConsumed() {
            HttpConnection.this.releaseRequestBuffer();
        }

        public String toString() {
            return super.toString() + "{" + HttpConnection.this._channel + "," + HttpConnection.this + "}";
        }
    }
}

