/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.CookieCutter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Request
implements HttpServletRequest {
    public static final String __MULTIPART_CONFIG_ELEMENT = "org.eclipse.multipartConfig";
    public static final String __MULTIPART_INPUT_STREAM = "org.eclipse.multiPartInputStream";
    public static final String __MULTIPART_CONTEXT = "org.eclipse.multiPartContext";
    private static final Logger LOG = Log.getLogger(Request.class);
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    private static final int __NONE = 0;
    private static final int _STREAM = 1;
    private static final int __READER = 2;
    private final HttpChannel<?> _channel;
    private final HttpFields _fields = new HttpFields();
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final HttpInput<?> _input;
    private boolean _secure;
    private boolean _asyncSupported = true;
    private boolean _newContext;
    private boolean _cookiesExtracted = false;
    private boolean _handled = false;
    private boolean _paramsExtracted;
    private boolean _requestedSessionIdFromCookie = false;
    private volatile Attributes _attributes;
    private Authentication _authentication;
    private MultiMap<String> _baseParameters;
    private String _characterEncoding;
    private ContextHandler.Context _context;
    private String _contextPath;
    private CookieCutter _cookies;
    private DispatcherType _dispatcherType;
    private int _inputState = 0;
    private HttpMethod _httpMethod;
    private String _httpMethodString;
    private MultiMap<String> _parameters;
    private String _pathInfo;
    private int _port;
    private HttpVersion _httpVersion = HttpVersion.HTTP_1_1;
    private String _queryEncoding;
    private String _queryString;
    private BufferedReader _reader;
    private String _readerEncoding;
    private InetSocketAddress _remote;
    private String _requestedSessionId;
    private String _requestURI;
    private Map<Object, HttpSession> _savedNewSessions;
    private String _scheme = "http";
    private UserIdentity.Scope _scope;
    private String _serverName;
    private String _servletPath;
    private HttpSession _session;
    private SessionManager _sessionManager;
    private long _timeStamp;
    private long _dispatchTime;
    private HttpURI _uri;
    private MultiPartInputStreamParser _multiPartInputStream;

    public Request(HttpChannel<?> channel, HttpInput<?> input) {
        this._channel = channel;
        this._input = input;
    }

    public HttpFields getHttpFields() {
        return this._fields;
    }

    public HttpInput<?> getHttpInput() {
        return this._input;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractParameters() {
        if (this._baseParameters == null) {
            this._baseParameters = new MultiMap();
        }
        if (this._paramsExtracted) {
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            }
            return;
        }
        this._paramsExtracted = true;
        try {
            int content_length;
            if (this._uri != null && this._uri.hasQuery()) {
                if (this._queryEncoding == null) {
                    this._uri.decodeQueryTo(this._baseParameters);
                } else {
                    try {
                        this._uri.decodeQueryTo(this._baseParameters, this._queryEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn((Throwable)e);
                        }
                        LOG.warn(e.toString(), new Object[0]);
                    }
                }
            }
            String encoding = this.getCharacterEncoding();
            String content_type = this.getContentType();
            if (content_type != null && content_type.length() > 0 && MimeTypes.Type.FORM_ENCODED.is(content_type = HttpFields.valueParameters((String)content_type, null)) && this._inputState == 0 && (HttpMethod.POST.is(this.getMethod()) || HttpMethod.PUT.is(this.getMethod())) && (content_length = this.getContentLength()) != 0) {
                try {
                    int maxFormContentSize = -1;
                    int maxFormKeys = -1;
                    if (this._context != null) {
                        maxFormContentSize = this._context.getContextHandler().getMaxFormContentSize();
                        maxFormKeys = this._context.getContextHandler().getMaxFormKeys();
                    } else {
                        Number size = (Number)this._channel.getServer().getAttribute("org.eclipse.jetty.server.Request.maxFormContentSize");
                        maxFormContentSize = size == null ? 200000 : size.intValue();
                        Number keys = (Number)this._channel.getServer().getAttribute("org.eclipse.jetty.server.Request.maxFormKeys");
                        int n = maxFormKeys = keys == null ? 1000 : keys.intValue();
                    }
                    if (content_length > maxFormContentSize && maxFormContentSize > 0) {
                        throw new IllegalStateException("Form too large" + content_length + ">" + maxFormContentSize);
                    }
                    ServletInputStream in = this.getInputStream();
                    UrlEncoded.decodeTo((InputStream)in, this._baseParameters, (String)encoding, (int)(content_length < 0 ? maxFormContentSize : -1), (int)maxFormKeys);
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Throwable)e);
                    }
                    LOG.warn(e.toString(), new Object[0]);
                }
            }
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            } else if (this._parameters != this._baseParameters) {
                this._parameters.addAllValues(this._baseParameters);
            }
        }
        finally {
            if (this._parameters == null) {
                this._parameters = this._baseParameters;
            }
        }
    }

    public AsyncContext getAsyncContext() {
        HttpChannelState continuation = this.getHttpChannelState();
        if (continuation.isInitial() && !continuation.isAsync()) {
            throw new IllegalStateException(continuation.getStatusString());
        }
        return continuation;
    }

    public HttpChannelState getHttpChannelState() {
        return this._channel.getState();
    }

    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public Attributes getAttributes() {
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        return this._attributes;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public int getContentLength() {
        return (int)this._fields.getLongField(HttpHeader.CONTENT_LENGTH.toString());
    }

    public String getContentType() {
        return this._fields.getStringField(HttpHeader.CONTENT_TYPE);
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public Cookie[] getCookies() {
        if (this._cookiesExtracted) {
            return this._cookies == null ? null : this._cookies.getCookies();
        }
        this._cookiesExtracted = true;
        Enumeration enm = this._fields.getValues(HttpHeader.COOKIE.toString());
        if (enm != null) {
            if (this._cookies == null) {
                this._cookies = new CookieCutter();
            }
            while (enm.hasMoreElements()) {
                String c = (String)enm.nextElement();
                this._cookies.addCookieField(c);
            }
        }
        return this._cookies == null ? null : this._cookies.getCookies();
    }

    public long getDateHeader(String name) {
        return this._fields.getDateField(name);
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }

    public String getHeader(String name) {
        return this._fields.getStringField(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._fields.getFieldNames();
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration e = this._fields.getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return e;
    }

    public int getInputState() {
        return this._inputState;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this._channel.isExpecting100Continue()) {
            this._channel.continue100(this._input.available());
        }
        return this._input;
    }

    public int getIntHeader(String name) {
        return (int)this._fields.getLongField(name);
    }

    public Locale getLocale() {
        Enumeration enm = this._fields.getValues(HttpHeader.ACCEPT_LANGUAGE.toString(), ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList((Enumeration)enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int size = acceptLanguage.size();
        if (size > 0) {
            String language = (String)acceptLanguage.get(0);
            language = HttpFields.valueParameters((String)language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        Enumeration enm = this._fields.getValues(HttpHeader.ACCEPT_LANGUAGE.toString(), ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList((Enumeration)enm);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        ArrayList<Locale> langs = new ArrayList<Locale>();
        for (String language : acceptLanguage) {
            language = HttpFields.valueParameters((String)language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs.add(new Locale(language, country));
        }
        if (langs.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(langs);
    }

    public String getLocalAddr() {
        InetSocketAddress local = this._channel.getLocalAddress();
        return local.getAddress().getHostAddress();
    }

    public String getLocalName() {
        InetSocketAddress local = this._channel.getLocalAddress();
        return local.getHostString();
    }

    public int getLocalPort() {
        InetSocketAddress local = this._channel.getLocalAddress();
        return local.getPort();
    }

    public String getMethod() {
        return this._httpMethodString;
    }

    public String getParameter(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(name, 0);
    }

    public Map<String, String[]> getParameterMap() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.unmodifiableMap(this._parameters.toStringArrayMap());
    }

    public Enumeration<String> getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return Collections.enumeration(this._parameters.keySet());
    }

    public MultiMap<String> getParameters() {
        return this._parameters;
    }

    public String[] getParameterValues(String name) {
        List vals;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if ((vals = this._parameters.getValues(name)) == null) {
            return null;
        }
        return vals.toArray(new String[vals.size()]);
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._context == null) {
            return null;
        }
        return this._context.getRealPath(this._pathInfo);
    }

    public String getProtocol() {
        return this._httpVersion.toString();
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    public String getQueryEncoding() {
        return this._queryEncoding;
    }

    public String getQueryString() {
        if (this._queryString == null && this._uri != null) {
            this._queryString = this._queryEncoding == null ? this._uri.getQuery() : this._uri.getQuery(this._queryEncoding);
        }
        return this._queryString;
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding)){

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRealPath(String path) {
        if (this._context == null) {
            return null;
        }
        return this._context.getRealPath(path);
    }

    public String getRemoteAddr() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return remote == null ? "" : remote.getHostString();
    }

    public String getRemoteHost() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return remote == null ? "" : remote.getHostString();
    }

    public int getRemotePort() {
        InetSocketAddress remote = this._remote;
        if (remote == null) {
            remote = this._channel.getRemoteAddress();
        }
        return remote == null ? 0 : remote.getPort();
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null || this._context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = URIUtil.addPaths((String)this._servletPath, (String)this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths((String)relTo, (String)path);
        }
        return this._context.getRequestDispatcher(path);
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    public String getRequestURI() {
        if (this._requestURI == null && this._uri != null) {
            this._requestURI = this._uri.getPathAndParam();
        }
        return this._requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(48);
        String scheme = this.getScheme();
        int port = this.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (this._port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(this._port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public Response getResponse() {
        return this._channel.getResponse();
    }

    public StringBuilder getRootURL() {
        StringBuilder url = new StringBuilder(48);
        String scheme = this.getScheme();
        int port = this.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        return url;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getServerName() {
        if (this._serverName != null) {
            return this._serverName;
        }
        if (this._uri == null) {
            throw new IllegalStateException("No uri");
        }
        this._serverName = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._serverName != null) {
            return this._serverName;
        }
        String hostPort = this._fields.getStringField(HttpHeader.HOST);
        if (hostPort != null) {
            int i = hostPort.length();
            block8: while (i-- > 0) {
                char ch = (char)(0xFF & hostPort.charAt(i));
                switch (ch) {
                    case ']': {
                        break block8;
                    }
                    case ':': {
                        this._serverName = hostPort.substring(0, i);
                        try {
                            this._port = StringUtil.toInt((String)hostPort.substring(i + 1));
                        }
                        catch (NumberFormatException e) {
                            LOG.warn((Throwable)e);
                        }
                        return this._serverName;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            if (this._serverName == null || this._port < 0) {
                this._serverName = hostPort;
                this._port = 0;
            }
            return this._serverName;
        }
        if (this._channel != null) {
            this._serverName = this.getLocalName();
            this._port = this.getLocalPort();
            if (this._serverName != null && !"0.0.0.0".equals(this._serverName)) {
                return this._serverName;
            }
        }
        try {
            this._serverName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.ignore((Throwable)e);
        }
        return this._serverName;
    }

    public int getServerPort() {
        if (this._port <= 0) {
            if (this._serverName == null) {
                this.getServerName();
            }
            if (this._port <= 0) {
                if (this._serverName != null && this._uri != null) {
                    this._port = this._uri.getPort();
                } else {
                    InetSocketAddress local = this._channel.getLocalAddress();
                    int n = this._port = local == null ? 0 : local.getPort();
                }
            }
        }
        if (this._port <= 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this._port;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public String getServletName() {
        if (this._scope != null) {
            return this._scope.getName();
        }
        return null;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            this._servletPath = "";
        }
        return this._servletPath;
    }

    public ServletResponse getServletResponse() {
        return this._channel.getResponse();
    }

    public String changeSessionId() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        if (session instanceof AbstractSession) {
            AbstractSession abstractSession = (AbstractSession)session;
            abstractSession.renewId(this);
            if (this.getRemoteUser() != null) {
                abstractSession.setAttribute("org.eclipse.jetty.security.sessionKnownOnlytoAuthenticated", Boolean.TRUE);
            }
            if (abstractSession.isIdChanged()) {
                this._channel.getResponse().addCookie(this._sessionManager.getSessionCookie(abstractSession, this.getContextPath(), this.isSecure()));
            }
        }
        return session.getId();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._sessionManager != null && !this._sessionManager.isValid(this._session)) {
                this._session = null;
            } else {
                return this._session;
            }
        }
        if (!create) {
            return null;
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._session = this._sessionManager.newHttpSession(this);
        HttpCookie cookie = this._sessionManager.getSessionCookie(this._session, this.getContextPath(), this.isSecure());
        if (cookie != null) {
            this._channel.getResponse().addCookie(cookie);
        }
        return this._session;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public HttpURI getUri() {
        return this._uri;
    }

    public UserIdentity getUserIdentity() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity getResolvedUserIdentity() {
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getUserIdentity();
        }
        return null;
    }

    public UserIdentity.Scope getUserIdentityScope() {
        return this._scope;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity user = ((Authentication.User)this._authentication).getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public long getDispatchTime() {
        return this._dispatchTime;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public boolean isAsyncStarted() {
        return this.getHttpChannelState().isAsync();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._requestedSessionId != null && this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._requestedSessionId != null && !this._requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdValid() {
        if (this._requestedSessionId == null) {
            return false;
        }
        HttpSession session = this.getSession(false);
        return session != null && this._sessionManager.getSessionIdManager().getClusterId(this._requestedSessionId).equals(this._sessionManager.getClusterId(session));
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public boolean isUserInRole(String role) {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(this._scope, role);
        }
        return false;
    }

    public HttpSession recoverNewSession(Object key) {
        if (this._savedNewSessions == null) {
            return null;
        }
        return this._savedNewSessions.get(key);
    }

    protected void recycle() {
        if (this._inputState == 2) {
            try {
                int r = this._reader.read();
                while (r != -1) {
                    r = this._reader.read();
                }
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
                this._reader = null;
            }
        }
        this.setAuthentication(Authentication.NOT_CHECKED);
        this.getHttpChannelState().recycle();
        this._asyncSupported = true;
        this._handled = false;
        if (this._context != null) {
            throw new IllegalStateException("Request in context!");
        }
        if (this._attributes != null) {
            this._attributes.clearAttributes();
        }
        this._characterEncoding = null;
        this._contextPath = null;
        if (this._cookies != null) {
            this._cookies.reset();
        }
        this._cookiesExtracted = false;
        this._context = null;
        this._serverName = null;
        this._httpMethodString = null;
        this._pathInfo = null;
        this._port = 0;
        this._httpVersion = HttpVersion.HTTP_1_1;
        this._queryEncoding = null;
        this._queryString = null;
        this._requestedSessionId = null;
        this._requestedSessionIdFromCookie = false;
        this._session = null;
        this._sessionManager = null;
        this._requestURI = null;
        this._scope = null;
        this._scheme = "http";
        this._servletPath = null;
        this._timeStamp = 0L;
        this._uri = null;
        if (this._baseParameters != null) {
            this._baseParameters.clear();
        }
        this._parameters = null;
        this._paramsExtracted = false;
        this._inputState = 0;
        if (this._savedNewSessions != null) {
            this._savedNewSessions.clear();
        }
        this._savedNewSessions = null;
        this._multiPartInputStream = null;
        this._remote = null;
        this._fields.clear();
        this._input.recycle();
    }

    public void removeAttribute(String name) {
        Object old_value;
        Object object = old_value = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
        if (old_value != null && !this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, old_value);
            for (ServletRequestAttributeListener listener : this._requestAttributeListeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    public void removeEventListener(EventListener listener) {
        this._requestAttributeListeners.remove(listener);
    }

    public void saveNewSession(Object key, HttpSession session) {
        if (this._savedNewSessions == null) {
            this._savedNewSessions = new HashMap<Object, HttpSession>();
        }
        this._savedNewSessions.put(key, session);
    }

    public void setAsyncSupported(boolean supported) {
        this._asyncSupported = supported;
    }

    public void setAttribute(String name, Object value) {
        Object old_value;
        Object object = old_value = this._attributes == null ? null : this._attributes.getAttribute(name);
        if (name.startsWith("org.eclipse.jetty.")) {
            if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
                this.setQueryEncoding(value == null ? null : value.toString());
            } else if ("org.eclipse.jetty.server.sendContent".equals(name)) {
                try {
                    ((HttpOutput)this.getServletResponse().getOutputStream()).sendContent(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if ("org.eclipse.jetty.server.ResponseBuffer".equals(name)) {
                try {
                    throw new IOException("not implemented");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(name, value);
        if (!this._requestAttributeListeners.isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._context, (ServletRequest)this, name, old_value == null ? value : old_value);
            for (ServletRequestAttributeListener l : this._requestAttributeListeners) {
                if (old_value == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
        if (!StringUtil.isUTF8((String)encoding)) {
            Charset.forName(encoding);
        }
    }

    public void setCharacterEncodingUnchecked(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setContentType(String contentType) {
        this._fields.put(HttpHeader.CONTENT_TYPE, contentType);
    }

    public void setContext(ContextHandler.Context context) {
        this._newContext = this._context != context;
        this._context = context;
    }

    public boolean takeNewContext() {
        boolean nc = this._newContext;
        this._newContext = false;
        return nc;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setCookies(Cookie[] cookies) {
        if (this._cookies == null) {
            this._cookies = new CookieCutter();
        }
        this._cookies.setCookies(cookies);
    }

    public void setDispatcherType(DispatcherType type) {
        this._dispatcherType = type;
    }

    public void setHandled(boolean h) {
        this._handled = h;
    }

    public void setMethod(HttpMethod httpMethod, String method) {
        this._httpMethod = httpMethod;
        this._httpMethodString = method;
    }

    public boolean isHead() {
        return HttpMethod.HEAD == this._httpMethod;
    }

    public void setParameters(MultiMap<String> parameters) {
        MultiMap<String> multiMap = this._parameters = parameters == null ? this._baseParameters : parameters;
        if (this._paramsExtracted && this._parameters == null) {
            throw new IllegalStateException();
        }
    }

    public void setPathInfo(String pathInfo) {
        this._pathInfo = pathInfo;
    }

    public void setHttpVersion(HttpVersion version) {
        this._httpVersion = version;
    }

    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = queryEncoding;
        this._queryString = null;
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString;
        this._queryEncoding = null;
    }

    public void setRemoteAddr(InetSocketAddress addr) {
        this._remote = addr;
    }

    public void setRequestedSessionId(String requestedSessionId) {
        this._requestedSessionId = requestedSessionId;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdCookie) {
        this._requestedSessionIdFromCookie = requestedSessionIdCookie;
    }

    public void setRequestURI(String requestURI) {
        this._requestURI = requestURI;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public void setServerName(String host) {
        this._serverName = host;
    }

    public void setServerPort(int port) {
        this._port = port;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }

    public void setSession(HttpSession session) {
        this._session = session;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public void setUri(HttpURI uri) {
        this._uri = uri;
    }

    public void setUserIdentityScope(UserIdentity.Scope scope) {
        this._scope = scope;
    }

    public void setDispatchTime(long value) {
        this._dispatchTime = value;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        HttpChannelState state = this.getHttpChannelState();
        state.startAsync();
        return state;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this._asyncSupported) {
            throw new IllegalStateException("!asyncSupported");
        }
        HttpChannelState state = this.getHttpChannelState();
        state.startAsync(this._context, servletRequest, servletResponse);
        return state;
    }

    public String toString() {
        return (this._handled ? "[" : "(") + this.getMethod() + " " + this._uri + (this._handled ? "]@" : ")@") + this.hashCode() + " " + super.toString();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((ServletRequest)this, (ServletResponse)response));
            return !(this._authentication instanceof Authentication.ResponseSent);
        }
        response.sendError(401);
        return false;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.getContentType() == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type != multipart/form-data");
        }
        if (this._multiPartInputStream == null) {
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute(__MULTIPART_CONFIG_ELEMENT);
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            this._multiPartInputStream = new MultiPartInputStreamParser((InputStream)this.getInputStream(), this.getContentType(), config, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null);
            this.setAttribute(__MULTIPART_INPUT_STREAM, this._multiPartInputStream);
            this.setAttribute(__MULTIPART_CONTEXT, (Object)this._context);
            Collection parts = this._multiPartInputStream.getParts();
            for (Part p : parts) {
                MultiPartInputStreamParser.MultiPart mp = (MultiPartInputStreamParser.MultiPart)p;
                if (mp.getContentDispositionFilename() != null || mp.getFile() != null) continue;
                String charset = null;
                if (mp.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType((String)mp.getContentType());
                }
                String content = new String(mp.getBytes(), charset == null ? "UTF-8" : charset);
                this.getParameter("");
                this.getParameters().add(mp.getName(), (Object)content);
            }
        }
        return this._multiPartInputStream.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.getContentType() == null || !this.getContentType().startsWith("multipart/form-data")) {
            throw new ServletException("Content-Type != multipart/form-data");
        }
        if (this._multiPartInputStream == null) {
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute(__MULTIPART_CONFIG_ELEMENT);
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            this._multiPartInputStream = new MultiPartInputStreamParser((InputStream)this.getInputStream(), this.getContentType(), config, this._context != null ? (File)this._context.getAttribute("javax.servlet.context.tempdir") : null);
            this.setAttribute(__MULTIPART_INPUT_STREAM, this._multiPartInputStream);
            this.setAttribute(__MULTIPART_CONTEXT, (Object)this._context);
            Collection parts = this._multiPartInputStream.getParts();
            for (Part p : parts) {
                MultiPartInputStreamParser.MultiPart mp = (MultiPartInputStreamParser.MultiPart)p;
                if (mp.getContentDispositionFilename() != null || mp.getFile() != null) continue;
                String charset = null;
                if (mp.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType((String)mp.getContentType());
                }
                String content = new String(mp.getBytes(), charset == null ? "UTF-8" : charset);
                this.getParameter("");
                this.getParameters().add(mp.getName(), (Object)content);
            }
        }
        return this._multiPartInputStream.getParts();
    }

    public void login(String username, String password) throws ServletException {
        if (this._authentication instanceof Authentication.Deferred) {
            this._authentication = ((Authentication.Deferred)this._authentication).login(username, password, (ServletRequest)this);
            if (this._authentication == null) {
                throw new ServletException("Authentication failed for " + username + " in " + this._authentication);
            }
        } else {
            throw new ServletException("Already authenticated as " + this._authentication);
        }
    }

    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.User) {
            ((Authentication.User)this._authentication).logout();
        }
        this._authentication = Authentication.UNAUTHENTICATED;
    }

    public void mergeQueryString(String query) {
        MultiMap parameters = new MultiMap();
        UrlEncoded.decodeTo((String)query, (MultiMap)parameters, (String)"UTF-8");
        boolean merge_old_query = false;
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        if (this._parameters != null && this._parameters.size() > 0) {
            merge_old_query = parameters.addAllValues(this._parameters);
        }
        if (this._queryString != null && this._queryString.length() > 0) {
            if (merge_old_query) {
                StringBuilder overridden_query_string = new StringBuilder();
                MultiMap overridden_old_query = new MultiMap();
                UrlEncoded.decodeTo((String)this._queryString, (MultiMap)overridden_old_query, (String)this.getQueryEncoding());
                MultiMap overridden_new_query = new MultiMap();
                UrlEncoded.decodeTo((String)query, (MultiMap)overridden_new_query, (String)"UTF-8");
                for (String name : overridden_old_query.keySet()) {
                    if (overridden_new_query.containsKey((Object)name)) continue;
                    List values = (List)overridden_old_query.get((Object)name);
                    for (String v : values) {
                        overridden_query_string.append("&").append(name).append("=").append(v);
                    }
                }
                query = query + overridden_query_string;
            } else {
                query = query + "&" + this._queryString;
            }
        }
        this.setParameters((MultiMap<String>)parameters);
        this.setQueryString(query);
    }

    public static class MultiPartCleanerListener
    implements ServletRequestListener {
        public void requestDestroyed(ServletRequestEvent sre) {
            ContextHandler.Context context;
            MultiPartInputStreamParser mpis = (MultiPartInputStreamParser)sre.getServletRequest().getAttribute(Request.__MULTIPART_INPUT_STREAM);
            if (mpis != null && (context = (ContextHandler.Context)((Object)sre.getServletRequest().getAttribute(Request.__MULTIPART_CONTEXT))) == sre.getServletContext()) {
                try {
                    mpis.deleteParts();
                }
                catch (MultiException e) {
                    sre.getServletContext().log("Errors deleting multipart tmp files", (Throwable)e);
                }
            }
        }

        public void requestInitialized(ServletRequestEvent sre) {
        }
    }
}

