/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class ServerConnectorListener
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private String _fileName;
    private String _sysPropertyName;

    public void lifeCycleStarted(LifeCycle event) {
        if (this.getFileName() != null) {
            File file = new File(this.getFileName());
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write(String.valueOf(((ServerConnector)event).getLocalPort()));
                writer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSysPropertyName() != null) {
            System.setProperty(this._sysPropertyName, String.valueOf(((ServerConnector)event).getLocalPort()));
        }
        super.lifeCycleStarted(event);
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    public String getSysPropertyName() {
        return this._sysPropertyName;
    }

    public void setSysPropertyName(String sysPropertyName) {
        this._sysPropertyName = sysPropertyName;
    }
}

