/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class OverlayConfig {
    private String targetPath;
    private String groupId;
    private String artifactId;
    private String classifier;
    private List<String> includes;
    private List<String> excludes;
    private boolean skip;
    private boolean filtered;

    public OverlayConfig() {
    }

    public OverlayConfig(String fmt, List<String> defaultIncludes, List<String> defaultExcludes) {
        if (fmt == null) {
            return;
        }
        String[] atoms = fmt.split(",");
        block10: for (int i = 0; i < atoms.length; ++i) {
            String s = atoms[i].trim();
            switch (i) {
                case 0: {
                    if ("".equals(s)) continue block10;
                    this.groupId = s;
                    continue block10;
                }
                case 1: {
                    if ("".equals(s)) continue block10;
                    this.artifactId = s;
                    continue block10;
                }
                case 2: {
                    if ("".equals(s)) continue block10;
                    this.classifier = s;
                    continue block10;
                }
                case 3: {
                    if ("".equals(s)) continue block10;
                    this.targetPath = s;
                    continue block10;
                }
                case 4: {
                    if ("".equals(s)) {
                        this.skip = false;
                        continue block10;
                    }
                    this.skip = Boolean.valueOf(s);
                    continue block10;
                }
                case 5: {
                    if ("".equals(s)) {
                        this.filtered = false;
                        continue block10;
                    }
                    this.filtered = Boolean.valueOf(s);
                    continue block10;
                }
                case 6: {
                    String[] incs;
                    if ("".equals(s) || (incs = s.split(";")).length <= 0) continue block10;
                    this.includes = Arrays.asList(incs);
                    continue block10;
                }
                case 7: {
                    String[] exs;
                    if ("".equals(s) || (exs = s.split(";")).length <= 0) continue block10;
                    this.excludes = Arrays.asList(exs);
                    continue block10;
                }
            }
        }
    }

    public OverlayConfig(Xpp3Dom root, List<String> defaultIncludes, List<String> defaultExcludes) {
        Xpp3Dom node = root.getChild("groupId");
        this.setGroupId(node == null ? null : node.getValue());
        node = root.getChild("artifactId");
        this.setArtifactId(node == null ? null : node.getValue());
        node = root.getChild("classifier");
        this.setClassifier(node == null ? null : node.getValue());
        node = root.getChild("targetPath");
        this.setTargetPath(node == null ? null : node.getValue());
        node = root.getChild("skip");
        this.setSkip(node == null ? false : Boolean.valueOf(node.getValue()));
        node = root.getChild("filtered");
        this.setFiltered(node == null ? false : Boolean.valueOf(node.getValue()));
        node = root.getChild("includes");
        ArrayList<String> includes = null;
        if (node != null && node.getChildCount() > 0) {
            Xpp3Dom[] list = node.getChildren("include");
            for (int j = 0; list != null && j < list.length; ++j) {
                if (includes == null) {
                    includes = new ArrayList();
                }
                includes.add(list[j].getValue());
            }
        }
        if (includes == null && defaultIncludes != null) {
            includes = new ArrayList<String>();
            includes.addAll(defaultIncludes);
        }
        this.setIncludes(includes);
        node = root.getChild("excludes");
        ArrayList<String> excludes = null;
        if (node != null && node.getChildCount() > 0) {
            Xpp3Dom[] list = node.getChildren("exclude");
            for (int j = 0; list != null && j < list.length; ++j) {
                if (excludes == null) {
                    excludes = new ArrayList();
                }
                excludes.add(list[j].getValue());
            }
        }
        if (excludes == null && defaultExcludes != null) {
            excludes = new ArrayList<String>();
            excludes.addAll(defaultExcludes);
        }
        this.setExcludes(excludes);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isCurrentProject() {
        return this.groupId == null && this.artifactId == null;
    }

    public String toString() {
        Iterator<String> itor;
        StringBuffer strbuff = new StringBuffer();
        strbuff.append((this.groupId != null ? this.groupId : "") + ",");
        strbuff.append((this.artifactId != null ? this.artifactId : "") + ",");
        strbuff.append((this.classifier != null ? this.classifier : "") + ",");
        strbuff.append((this.targetPath != null ? this.targetPath : "") + ",");
        strbuff.append("" + this.skip + ",");
        strbuff.append("" + this.filtered + ",");
        if (this.includes != null) {
            itor = this.includes.iterator();
            while (itor.hasNext()) {
                strbuff.append(itor.next());
                if (!itor.hasNext()) continue;
                strbuff.append(";");
            }
        }
        strbuff.append(", ");
        if (this.excludes != null) {
            itor = this.excludes.iterator();
            while (itor.hasNext()) {
                strbuff.append(itor.next());
                if (!itor.hasNext()) continue;
                strbuff.append(";");
            }
        }
        return strbuff.toString();
    }
}

