/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.jetty.maven.plugin.JettyServer;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.MavenServerConnector;
import org.eclipse.jetty.maven.plugin.Monitor;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Starter {
    public static final String PORT_SYSPROPERTY = "jetty.port";
    private static final Logger LOG = Log.getLogger(Starter.class);
    private List<File> jettyXmls;
    private File contextXml;
    private JettyServer server;
    private JettyWebAppContext webApp;
    private Monitor monitor;
    private int stopPort = 0;
    private String stopKey = null;
    private Properties props;
    private String token;

    public void configureJetty() throws Exception {
        HandlerCollection handlers;
        LOG.debug("Starting Jetty Server ...", new Object[0]);
        this.server = JettyServer.getInstance();
        this.applyJettyXml();
        Connector[] connectors = this.server.getConnectors();
        if (connectors == null || connectors.length == 0) {
            MavenServerConnector httpConnector = new MavenServerConnector();
            String tmp = System.getProperty(PORT_SYSPROPERTY, MavenServerConnector.DEFAULT_PORT_STR);
            httpConnector.setPort(Integer.parseInt(tmp.trim()));
            connectors = new Connector[]{httpConnector};
            this.server.setConnectors(connectors);
        }
        if ((handlers = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class)) == null) {
            handlers = new HandlerCollection();
            this.server.setHandler((Handler)handlers);
        }
        this.server.configureHandlers();
        this.webApp = new JettyWebAppContext();
        this.configureWebApp();
        if (this.contextXml != null) {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)this.contextXml));
            xmlConfiguration.getIdMap().put("Server", this.server);
            xmlConfiguration.configure((Object)this.webApp);
        }
        this.server.addWebApplication(this.webApp);
        System.err.println("STOP PORT=" + this.stopPort + ", STOP KEY=" + this.stopKey);
        if (this.stopPort > 0 && this.stopKey != null) {
            this.monitor = new Monitor(this.stopPort, this.stopKey, new Server[]{this.server}, true);
        }
    }

    public void configureWebApp() throws Exception {
        Overlay overlay;
        if (this.props == null) {
            return;
        }
        String str = (String)this.props.get("context.path");
        if (str != null) {
            this.webApp.setContextPath(str);
        }
        if ((str = (String)this.props.get("web.xml")) != null) {
            this.webApp.setDescriptor(str);
        }
        if ((str = this.props.getProperty("tmp.dir")) != null) {
            this.webApp.setTempDirectory(new File(str.trim()));
        }
        if ((str = this.props.getProperty("base.dir")) != null && !"".equals(str.trim())) {
            this.webApp.setWar(str);
            this.webApp.setBaseResource(Resource.newResource((String)str));
        }
        if ((str = this.props.getProperty("base.first")) != null && !"".equals(str.trim())) {
            this.webApp.setBaseAppFirst(Boolean.getBoolean(str));
        }
        str = this.props.getProperty("maven.war.includes");
        List<String> defaultWarIncludes = this.fromCSV(str);
        str = this.props.getProperty("maven.war.excludes");
        List<String> defaultWarExcludes = this.fromCSV(str);
        ArrayList<Artifact> wars = new ArrayList<Artifact>();
        TreeMap<String, OverlayConfig> orderedConfigs = new TreeMap<String, OverlayConfig>();
        Enumeration<?> pnames = this.props.propertyNames();
        while (pnames.hasMoreElements()) {
            String n = (String)pnames.nextElement();
            if (n.startsWith("maven.war.artifact")) {
                Artifact a = new Artifact((String)this.props.get(n));
                a.resource = Resource.newResource((String)("jar:" + Resource.toURL((File)new File(a.path)).toString() + "!/"));
                wars.add(a);
                continue;
            }
            if (!n.startsWith("maven.war.overlay")) continue;
            OverlayConfig c = new OverlayConfig((String)this.props.get(n), defaultWarIncludes, defaultWarExcludes);
            orderedConfigs.put(n, c);
        }
        HashSet<Artifact> matchedWars = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : orderedConfigs.values()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.getArtifactForOverlayConfig(config, wars);
            if (a == null) continue;
            matchedWars.add(a);
            SelectiveJarResource r = new SelectiveJarResource(new URL("jar:" + Resource.toURL((File)new File(a.path)).toString() + "!/"));
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay2 = new Overlay(config, (Resource)r);
            overlays.add(overlay2);
        }
        for (Artifact a : wars) {
            if (matchedWars.contains(a)) continue;
            overlay = new Overlay(null, a.resource);
            overlays.add(overlay);
        }
        this.webApp.setOverlays(overlays);
        str = this.props.getProperty("classes.dir");
        if (str != null && !"".equals(str.trim())) {
            this.webApp.setClasses(new File(str));
        }
        if ((str = this.props.getProperty("testClasses.dir")) != null && !"".equals(str.trim())) {
            this.webApp.setTestClasses(new File(str));
        }
        if ((str = this.props.getProperty("lib.jars")) != null && !"".equals(str.trim())) {
            ArrayList<File> jars = new ArrayList<File>();
            String[] names = str.split(",");
            for (int j = 0; names != null && j < names.length; ++j) {
                jars.add(new File(names[j].trim()));
            }
            this.webApp.setWebInfLib(jars);
        }
    }

    public void getConfiguration(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("--stop-port".equals(args[i])) {
                this.stopPort = Integer.parseInt(args[++i]);
            }
            if ("--stop-key".equals(args[i])) {
                this.stopKey = args[++i];
            }
            if ("--jetty-xml".equals(args[i])) {
                this.jettyXmls = new ArrayList<File>();
                String[] names = args[++i].split(",");
                for (int j = 0; names != null && j < names.length; ++j) {
                    this.jettyXmls.add(new File(names[j].trim()));
                }
            }
            if ("--context-xml".equals(args[i])) {
                this.contextXml = new File(args[++i]);
            }
            if ("--props".equals(args[i])) {
                File f = new File(args[++i].trim());
                this.props = new Properties();
                this.props.load(new FileInputStream(f));
            }
            if (!"--token".equals(args[i])) continue;
            this.token = args[++i].trim();
        }
    }

    public void run() throws Exception {
        if (this.monitor != null) {
            this.monitor.start();
        }
        LOG.info("Started Jetty Server", new Object[0]);
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void communicateStartupResult(Exception e) {
        if (this.token != null) {
            if (e == null) {
                System.out.println(this.token);
            } else {
                System.out.println(this.token + "\t" + e.getMessage());
            }
        }
    }

    public void applyJettyXml() throws Exception {
        if (this.jettyXmls == null) {
            return;
        }
        for (File xmlFile : this.jettyXmls) {
            LOG.info("Configuring Jetty from xml configuration file = " + xmlFile.getCanonicalPath(), new Object[0]);
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)xmlFile));
            xmlConfiguration.configure((Object)this.server);
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    protected Artifact getArtifactForOverlayConfig(OverlayConfig c, List<Artifact> wars) {
        if (wars == null || wars.isEmpty() || c == null) {
            return null;
        }
        Artifact war = null;
        Iterator<Artifact> itor = wars.iterator();
        while (itor.hasNext() && war == null) {
            Artifact a = itor.next();
            if ((c.getGroupId() != null || a.gid != null) && (c.getGroupId() == null || !c.getGroupId().equals(a.gid)) || (c.getArtifactId() != null || a.aid != null) && (c.getArtifactId() == null || !c.getArtifactId().equals(a.aid)) || c.getClassifier() != null && !c.getClassifier().equals(a.aid)) continue;
            war = a;
        }
        return war;
    }

    private List<String> fromCSV(String csv) {
        if (csv == null || "".equals(csv.trim())) {
            return null;
        }
        String[] atoms = csv.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String a : atoms) {
            list.add(a.trim());
        }
        return list;
    }

    public static final void main(String[] args) {
        if (args == null) {
            System.exit(1);
        }
        Starter starter = null;
        try {
            starter = new Starter();
            starter.getConfiguration(args);
            starter.configureJetty();
            starter.run();
            starter.communicateStartupResult(null);
            starter.join();
        }
        catch (Exception e) {
            starter.communicateStartupResult(e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public class Artifact {
        public String gid;
        public String aid;
        public String path;
        public Resource resource;

        public Artifact(String csv) {
            String[] atoms;
            if (csv != null && !"".equals(csv) && (atoms = csv.split(",")).length >= 3) {
                this.gid = atoms[0].trim();
                this.aid = atoms[1].trim();
                this.path = atoms[2].trim();
            }
        }

        public Artifact(String gid, String aid, String path) {
            this.gid = gid;
            this.aid = aid;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Artifact)) {
                return false;
            }
            Artifact ao = (Artifact)o;
            return (this.gid == null && ao.gid == null || this.gid != null && this.gid.equals(ao.gid)) && (this.aid == null && ao.aid == null || this.aid != null && this.aid.equals(ao.aid));
        }
    }
}

