/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServletAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(WebServletAnnotation.class);

    public WebServletAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            LOG.warn(clazz.getName() + " is not assignable from javax.servlet.http.HttpServlet", new Object[0]);
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            LOG.warn(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns", new Object[0]);
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            LOG.warn(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns", new Object[0]);
            return;
        }
        ArrayList<String> urlPatternList = new ArrayList<String>();
        for (String p : urlPatterns) {
            urlPatternList.add(Util.normalizePattern(p));
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        MetaData metaData = this._context.getMetaData();
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        boolean isNew = true;
        ServletHolder holder = null;
        if (holders != null) {
            for (ServletHolder servletHolder : holders) {
                if (servletHolder.getName() == null || !servletName.equals(servletHolder.getName())) continue;
                holder = servletHolder;
                isNew = false;
                break;
            }
        }
        if (isNew) {
            holder = this._context.getServletHandler().newServletHolder(Holder.Source.ANNOTATION);
            holder.setHeldClass(clazz);
            metaData.setOrigin(servletName + ".servlet.servlet-class");
            holder.setName(servletName);
            holder.setDisplayName(annotation.displayName());
            metaData.setOrigin(servletName + ".servlet.display-name");
            holder.setInitOrder(annotation.loadOnStartup());
            metaData.setOrigin(servletName + ".servlet.load-on-startup");
            holder.setAsyncSupported(annotation.asyncSupported());
            metaData.setOrigin(servletName + ".servlet.async-supported");
            for (ServletHolder servletHolder : annotation.initParams()) {
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + servletHolder.name());
            }
            this._context.getServletHandler().addServlet(holder);
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(holder.getName());
            mapping.setPathSpecs(LazyList.toStringArray(urlPatternList));
            this._context.getServletHandler().addServletMapping(mapping);
            metaData.setOrigin(servletName + ".servlet.mappings");
        } else {
            boolean bl;
            if (holder.getClassName() == null) {
                holder.setClassName(clazz.getName());
            }
            if (holder.getHeldClass() == null) {
                holder.setHeldClass(clazz);
            }
            for (ServletHolder servletHolder : annotation.initParams()) {
                if (metaData.getOrigin(servletName + ".servlet.init-param" + servletHolder.name()) != Origin.NotSet) continue;
                holder.setInitParameter(servletHolder.name(), servletHolder.value());
                metaData.setOrigin(servletName + ".servlet.init-param." + servletHolder.name());
            }
            boolean mappingsExist = false;
            boolean anyNonDefaults = false;
            ServletMapping[] allMappings = this._context.getServletHandler().getServletMappings();
            if (allMappings != null) {
                for (ServletMapping m : allMappings) {
                    if (m.getServletName() == null || !servletName.equals(m.getServletName())) continue;
                    mappingsExist = true;
                    if (m.isDefault()) continue;
                    anyNonDefaults = true;
                    break;
                }
            }
            if (anyNonDefaults) {
                return;
            }
            boolean bl2 = false;
            if (mappingsExist) {
                for (String p : urlPatternList) {
                    ServletMapping m;
                    m = this._context.getServletHandler().getServletMapping(p);
                    if (m == null || m.isDefault()) continue;
                    bl = true;
                    break;
                }
            }
            if (!mappingsExist || !bl) {
                ServletMapping m = new ServletMapping();
                m.setServletName(servletName);
                m.setPathSpecs(LazyList.toStringArray(urlPatternList));
                this._context.getServletHandler().addServletMapping(m);
            }
        }
    }
}

