/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;

public class JDBCSessionManager
extends AbstractSessionManager {
    protected String __insertSession;
    protected String __deleteSession;
    protected String __selectSession;
    protected String __updateSession;
    protected String __updateSessionNode;
    protected String __updateSessionAccessTime;
    private ConcurrentHashMap _sessions;
    protected long _saveIntervalSec = 60L;

    public void setSaveInterval(long sec) {
        this._saveIntervalSec = sec;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String idInCluster) {
        Session session = (Session)this._sessions.get(idInCluster);
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            try {
                SessionData data = null;
                long now = System.currentTimeMillis();
                if (Log.isDebugEnabled()) {
                    Log.debug("now=" + now + " lastSaved=" + (session == null ? 0L : session._data._lastSaved) + " interval=" + this._saveIntervalSec * 1000L + " difference=" + (now - (session == null ? 0L : session._data._lastSaved)));
                }
                if ((data = session == null || now - session._data._lastSaved >= this._saveIntervalSec * 1000L ? this.loadSession(idInCluster, this.canonicalize(this._context.getContextPath()), this.getVirtualHost(this._context)) : session._data) != null) {
                    if (!data.getLastNode().equals(this.getIdManager().getWorkerName()) || session == null) {
                        if (data._expiryTime > System.currentTimeMillis()) {
                            session = new Session(data);
                            this._sessions.put(idInCluster, session);
                            session.didActivate();
                            this.updateSessionNode(data);
                        }
                    } else if (Log.isDebugEnabled()) {
                        Log.debug("Session not stale " + session._data);
                    }
                } else {
                    session = null;
                    if (Log.isDebugEnabled()) {
                        Log.debug("No session in database matching id=" + idInCluster);
                    }
                }
                return session;
            }
            catch (Exception e) {
                Log.warn("Unable to load session from database", e);
                return null;
            }
        }
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessions() {
        int size = 0;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            size = this._sessions.size();
        }
        return size;
    }

    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this.prepareTables();
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    public void doStop() throws Exception {
        this._sessions.clear();
        this._sessions = null;
        super.doStop();
    }

    protected void invalidateSessions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            session = (Session)this._sessions.get(idInCluster);
        }
        if (session != null) {
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            session = (Session)this._sessions.remove(idInCluster);
        }
        try {
            if (session != null) {
                this.deleteSession(session._data);
            }
        }
        catch (Exception e) {
            Log.warn("Problem deleting session id=" + idInCluster, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSessionManager.Session session) {
        if (session == null) {
            return;
        }
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            this._sessions.put(session.getClusterId(), session);
        }
        try {
            session.willPassivate();
            this.storeSession(((Session)session)._data);
            session.didActivate();
        }
        catch (Exception e) {
            Log.warn("Unable to store new session id=" + session.getId(), e);
        }
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new Session(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(AbstractSessionManager.Session session, boolean invalidate) {
        boolean removed = false;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            if (this.getSession(session.getClusterId()) != null) {
                removed = true;
                this.removeSession(session.getClusterId());
            }
        }
        if (removed) {
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                int i = LazyList.size(this._sessionListeners);
                while (i-- > 0) {
                    ((HttpSessionListener)LazyList.get(this._sessionListeners, i)).sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(List sessionIds) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        ListIterator itor = sessionIds.listIterator();
        try {
            while (itor.hasNext()) {
                Session session;
                String sessionId = (String)itor.next();
                if (Log.isDebugEnabled()) {
                    Log.debug("Expiring session id " + sessionId);
                }
                if ((session = (Session)this._sessions.get(sessionId)) != null) {
                    session.timeout();
                    itor.remove();
                    continue;
                }
                if (!Log.isDebugEnabled()) continue;
                Log.debug("Unrecognized session id=" + sessionId);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Log.warn("Problem expiring sessions", t);
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void prepareTables() {
        this.__insertSession = "insert into " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " (rowId, sessionId, contextPath, virtualHost, lastNode, accessTime, lastAccessTime, createTime, cookieTime, lastSavedTime, expiryTime, map) " + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.__deleteSession = "delete from " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " where rowId = ?";
        this.__selectSession = "select * from " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " where sessionId = ? and contextPath = ? and virtualHost = ?";
        this.__updateSession = "update " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " set lastNode = ?, accessTime = ?, lastAccessTime = ?, lastSavedTime = ?, expiryTime = ?, map = ? where rowId = ?";
        this.__updateSessionNode = "update " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " set lastNode = ? where rowId = ?";
        this.__updateSessionAccessTime = "update " + ((JDBCSessionIdManager)this._sessionIdManager)._sessionTable + " set lastNode = ?, accessTime = ?, lastAccessTime = ?, lastSavedTime = ?, expiryTime = ? where rowId = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionData loadSession(String id, String canonicalContextPath, String vhost) throws Exception {
        SessionData data = null;
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.__selectSession);
            statement.setString(1, id);
            statement.setString(2, canonicalContextPath);
            statement.setString(3, vhost);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                data = new SessionData(id);
                data.setRowId(result.getString("rowId"));
                data.setCookieSet(result.getLong("cookieTime"));
                data.setLastAccessed(result.getLong("lastAccessTime"));
                data.setAccessed(result.getLong("accessTime"));
                data.setCreated(result.getLong("createTime"));
                data.setLastNode(result.getString("lastNode"));
                data.setLastSaved(result.getLong("lastSavedTime"));
                data.setExpiryTime(result.getLong("expiryTime"));
                data.setCanonicalContext(result.getString("contextPath"));
                data.setVirtualHost(result.getString("virtualHost"));
                InputStream is = ((JDBCSessionIdManager)this.getIdManager())._dbAdaptor.getBlobInputStream(result, "map");
                ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);
                Object o = ois.readObject();
                data.setAttributeMap((ConcurrentHashMap)o);
                ois.close();
                if (Log.isDebugEnabled()) {
                    Log.debug("LOADED session " + data);
                }
            }
            SessionData sessionData = data;
            return sessionData;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            String rowId = this.calculateRowId(data);
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this.__insertSession);
            statement.setString(1, rowId);
            statement.setString(2, data.getId());
            statement.setString(3, data.getCanonicalContext());
            statement.setString(4, data.getVirtualHost());
            statement.setString(5, this.getIdManager().getWorkerName());
            statement.setLong(6, data.getAccessed());
            statement.setLong(7, data.getLastAccessed());
            statement.setLong(8, data.getCreated());
            statement.setLong(9, data.getCookieSet());
            statement.setLong(10, now);
            statement.setLong(11, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(12, (InputStream)bais, bytes.length);
            statement.executeUpdate();
            data.setRowId(rowId);
            data.setLastSaved(now);
            if (Log.isDebugEnabled()) {
                Log.debug("Stored session " + data);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this.__updateSession);
            statement.setString(1, this.getIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(6, (InputStream)bais, bytes.length);
            statement.setString(7, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            if (Log.isDebugEnabled()) {
                Log.debug("Updated session " + data);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSessionNode(SessionData data) throws Exception {
        String nodeId = this.getIdManager().getWorkerName();
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this.__updateSessionNode);
            statement.setString(1, nodeId);
            statement.setString(2, data.getRowId());
            statement.executeUpdate();
            statement.close();
            if (Log.isDebugEnabled()) {
                Log.debug("Updated last node for session id=" + data.getId() + ", lastNode = " + nodeId);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionAccessTime(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this.__updateSessionAccessTime);
            statement.setString(1, this.getIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            statement.setString(6, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            statement.close();
            if (Log.isDebugEnabled()) {
                Log.debug("Updated access time session id=" + data.getId());
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSession(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this.__deleteSession);
            statement.setString(1, data.getRowId());
            statement.executeUpdate();
            if (Log.isDebugEnabled()) {
                Log.debug("Deleted Session " + data);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return ((JDBCSessionIdManager)this.getIdManager()).getConnection();
    }

    private String calculateRowId(SessionData data) {
        String rowId = this.canonicalize(this._context.getContextPath());
        rowId = rowId + "_" + this.getVirtualHost(this._context);
        rowId = rowId + "_" + data.getId();
        return rowId;
    }

    private String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        public Class resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }

    public class Session
    extends AbstractSessionManager.Session {
        private final SessionData _data;
        private boolean _dirty;

        protected Session(HttpServletRequest request) {
            super(JDBCSessionManager.this, request);
            this._dirty = false;
            this._data = new SessionData(this._clusterId);
            this._data.setMaxIdleMs(JDBCSessionManager.this._dftMaxIdleSecs * 1000);
            this._data.setCanonicalContext(JDBCSessionManager.this.canonicalize(JDBCSessionManager.this._context.getContextPath()));
            this._data.setVirtualHost(JDBCSessionManager.this.getVirtualHost(JDBCSessionManager.this._context));
            this._data.setExpiryTime(this._maxIdleMs < 0L ? 0L : System.currentTimeMillis() + this._maxIdleMs);
            this._values = this._data.getAttributeMap();
        }

        protected Session(SessionData data) {
            super(JDBCSessionManager.this, data.getCreated(), data.getId());
            this._dirty = false;
            this._data = data;
            this._data.setMaxIdleMs(JDBCSessionManager.this._dftMaxIdleSecs * 1000);
            this._values = data.getAttributeMap();
        }

        protected Map newAttributeMap() {
            return this._data.getAttributeMap();
        }

        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            this._dirty = true;
        }

        public void removeAttribute(String name) {
            super.removeAttribute(name);
            this._dirty = true;
        }

        protected void cookieSet() {
            this._data.setCookieSet(this._data.getAccessed());
        }

        protected void access(long time) {
            super.access(time);
            this._data.setLastAccessed(this._data.getAccessed());
            this._data.setAccessed(time);
            this._data.setExpiryTime(this._maxIdleMs < 0L ? 0L : time + this._maxIdleMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            super.complete();
            try {
                if (this._dirty) {
                    this.willPassivate();
                    JDBCSessionManager.this.updateSession(this._data);
                    this.didActivate();
                } else if (this._data._accessed - this._data._lastSaved >= JDBCSessionManager.this.getSaveInterval() * 1000L) {
                    JDBCSessionManager.this.updateSessionAccessTime(this._data);
                }
            }
            catch (Exception e) {
                Log.warn("Problem persisting changed session data id=" + this.getId(), e);
            }
            finally {
                this._dirty = false;
            }
        }

        protected void timeout() throws IllegalStateException {
            if (Log.isDebugEnabled()) {
                Log.debug("Timing out session id=" + this.getClusterId());
            }
            super.timeout();
        }
    }

    public class SessionData {
        private final String _id;
        private String _rowId;
        private long _accessed;
        private long _lastAccessed;
        private long _maxIdleMs;
        private long _cookieSet;
        private long _created;
        private Map _attributes;
        private String _lastNode;
        private String _canonicalContext;
        private long _lastSaved;
        private long _expiryTime;
        private String _virtualHost;

        public SessionData(String sessionId) {
            this._id = sessionId;
            this._accessed = this._created = System.currentTimeMillis();
            this._attributes = new ConcurrentHashMap();
            this._lastNode = JDBCSessionManager.this.getIdManager().getWorkerName();
        }

        public synchronized String getId() {
            return this._id;
        }

        public synchronized long getCreated() {
            return this._created;
        }

        protected synchronized void setCreated(long ms) {
            this._created = ms;
        }

        public synchronized long getAccessed() {
            return this._accessed;
        }

        protected synchronized void setAccessed(long ms) {
            this._accessed = ms;
        }

        public synchronized void setMaxIdleMs(long ms) {
            this._maxIdleMs = ms;
        }

        public synchronized long getMaxIdleMs() {
            return this._maxIdleMs;
        }

        public synchronized void setLastAccessed(long ms) {
            this._lastAccessed = ms;
        }

        public synchronized long getLastAccessed() {
            return this._lastAccessed;
        }

        public void setCookieSet(long ms) {
            this._cookieSet = ms;
        }

        public synchronized long getCookieSet() {
            return this._cookieSet;
        }

        public synchronized void setRowId(String rowId) {
            this._rowId = rowId;
        }

        protected synchronized String getRowId() {
            return this._rowId;
        }

        protected synchronized Map getAttributeMap() {
            return this._attributes;
        }

        protected synchronized void setAttributeMap(ConcurrentHashMap map) {
            this._attributes = map;
        }

        public synchronized void setLastNode(String node) {
            this._lastNode = node;
        }

        public synchronized String getLastNode() {
            return this._lastNode;
        }

        public synchronized void setCanonicalContext(String str) {
            this._canonicalContext = str;
        }

        public synchronized String getCanonicalContext() {
            return this._canonicalContext;
        }

        public synchronized long getLastSaved() {
            return this._lastSaved;
        }

        public synchronized void setLastSaved(long time) {
            this._lastSaved = time;
        }

        public synchronized void setExpiryTime(long time) {
            this._expiryTime = time;
        }

        public synchronized long getExpiryTime() {
            return this._expiryTime;
        }

        public synchronized void setVirtualHost(String vhost) {
            this._virtualHost = vhost;
        }

        public synchronized String getVirtualHost() {
            return this._virtualHost;
        }

        public String toString() {
            return "Session rowId=" + this._rowId + ",id=" + this._id + ",lastNode=" + this._lastNode + ",created=" + this._created + ",accessed=" + this._accessed + ",lastAccessed=" + this._lastAccessed + ",cookieSet=" + this._cookieSet + "lastSaved=" + this._lastSaved;
        }
    }
}

