/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MBeanContainer
implements Container.InheritedListener,
Dumpable {
    private static final Logger LOG = Log.getLogger(MBeanContainer.class.getName());
    private static final ConcurrentMap<String, AtomicInteger> __unique = new ConcurrentHashMap<String, AtomicInteger>();
    private final MBeanServer _mbeanServer;
    private final WeakHashMap<Object, ObjectName> _beans = new WeakHashMap();
    private String _domain = null;

    public static void resetUnique() {
        __unique.clear();
    }

    public synchronized ObjectName findMBean(Object object) {
        ObjectName bean = this._beans.get(object);
        return bean == null ? null : bean;
    }

    public synchronized Object findBean(ObjectName oname) {
        for (Map.Entry<Object, ObjectName> entry : this._beans.entrySet()) {
            ObjectName bean = entry.getValue();
            if (!bean.equals(oname)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._mbeanServer = server;
    }

    public MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    @Override
    public void beanAdded(Container parent, Object obj) {
        LOG.debug("beanAdded {}->{}", parent, obj);
        ObjectName pname = null;
        if (parent != null && (pname = this._beans.get(parent)) == null) {
            this.beanAdded(null, parent);
            pname = this._beans.get(parent);
        }
        if (obj == null || this._beans.containsKey(obj)) {
            return;
        }
        try {
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName oname = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                oname = ((ObjectMBean)mbean).getObjectName();
            }
            if (oname == null) {
                String basis;
                AtomicInteger count;
                String name;
                String context;
                String type;
                int dot;
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                if ((dot = (type = obj.getClass().getName().toLowerCase(Locale.ENGLISH)).lastIndexOf(46)) >= 0) {
                    type = type.substring(dot + 1);
                }
                StringBuffer buf = new StringBuffer();
                String string = context = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectContextBasis()) : null;
                if (context == null && pname != null) {
                    context = pname.getKeyProperty("context");
                }
                if (context != null && context.length() > 1) {
                    buf.append("context=").append(context).append(",");
                }
                buf.append("type=").append(type);
                String string2 = name = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectNameBasis()) : context;
                if (name != null && name.length() > 1) {
                    buf.append(",").append("name=").append(name);
                }
                if ((count = (AtomicInteger)__unique.get(basis = buf.toString())) == null && (count = __unique.putIfAbsent(basis, new AtomicInteger())) == null) {
                    count = (AtomicInteger)__unique.get(basis);
                }
                oname = ObjectName.getInstance(domain + ":" + basis + ",id=" + count.getAndIncrement());
            }
            ObjectInstance oinstance = this._mbeanServer.registerMBean(mbean, oname);
            LOG.debug("Registered {}", oinstance.getObjectName());
            this._beans.put(obj, oinstance.getObjectName());
        }
        catch (Exception e) {
            LOG.warn("bean: " + obj, e);
        }
    }

    @Override
    public void beanRemoved(Container parent, Object obj) {
        LOG.debug("beanRemoved {}", obj);
        ObjectName bean = this._beans.remove(obj);
        if (bean != null) {
            try {
                this._mbeanServer.unregisterMBean(bean);
                LOG.debug("Unregistered {}", bean);
            }
            catch (InstanceNotFoundException e) {
                LOG.ignore(e);
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    public String makeName(String basis) {
        if (basis == null) {
            return basis;
        }
        return basis.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, this._beans.entrySet());
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    public void destroy() {
        for (ObjectName oname : this._beans.values()) {
            if (oname == null) continue;
            try {
                this._mbeanServer.unregisterMBean(oname);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                LOG.warn(e);
            }
        }
    }
}

