/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class MultiPartFilter
implements Filter {
    private static final String FILES = "org.eclipse.jetty.servlet.MultiPartFilter.files";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        this._context = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        InputStream in = new BufferedInputStream((InputStream)request.getInputStream());
        String content_type = srequest.getContentType();
        String boundary = "--" + QuotedStringTokenizer.unquote(this.value(content_type.substring(content_type.indexOf("boundary="))).trim());
        byte[] byteBoundary = (boundary + "--").getBytes("ISO-8859-1");
        MultiMap params = new MultiMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                params.addValues(entry.getKey(), (String[])value);
                continue;
            }
            params.add(entry.getKey(), value);
        }
        try {
            String line;
            byte[] bytes = TypeUtil.readLine(in);
            String string = line = bytes == null ? null : new String(bytes, "UTF-8");
            if (line == null || !line.equals(boundary)) {
                throw new IOException("Missing initial multi part boundary");
            }
            boolean lastPart = false;
            String content_disposition = null;
            String content_transfer_encoding = null;
            block7: while (!lastPart) {
                while ((bytes = TypeUtil.readLine(in)) != null) {
                    if (bytes.length != 0) {
                        line = new String(bytes, "UTF-8");
                        int c = line.indexOf(58, 0);
                        if (c <= 0) continue;
                        String key = line.substring(0, c).trim().toLowerCase();
                        String value = line.substring(c + 1, line.length()).trim();
                        if (key.equals("content-disposition")) {
                            content_disposition = value;
                            continue;
                        }
                        if (!key.equals("content-transfer-encoding")) continue;
                        content_transfer_encoding = value;
                        continue;
                    }
                    boolean form_data = false;
                    if (content_disposition == null) {
                        throw new IOException("Missing content-disposition");
                    }
                    QuotedStringTokenizer tok = new QuotedStringTokenizer(content_disposition, ";");
                    String name = null;
                    String filename = null;
                    while (tok.hasMoreTokens()) {
                        String t = tok.nextToken().trim();
                        String tl = t.toLowerCase();
                        if (t.startsWith("form-data")) {
                            form_data = true;
                            continue;
                        }
                        if (tl.startsWith("name=")) {
                            name = this.value(t);
                            continue;
                        }
                        if (!tl.startsWith("filename=")) continue;
                        filename = this.value(t);
                    }
                    if (!form_data || name == null) continue block7;
                    OutputStream out = null;
                    File file = null;
                    try {
                        if (filename != null && filename.length() > 0) {
                            file = File.createTempFile("MultiPart", "", this.tempdir);
                            out = new FileOutputStream(file);
                            if (this._fileOutputBuffer > 0) {
                                out = new BufferedOutputStream(out, this._fileOutputBuffer);
                            }
                            request.setAttribute(name, (Object)file);
                            params.add(name, filename);
                            if (this._deleteFiles) {
                                file.deleteOnExit();
                                ArrayList<File> files = (ArrayList<File>)request.getAttribute(FILES);
                                if (files == null) {
                                    files = new ArrayList<File>();
                                    request.setAttribute(FILES, files);
                                }
                                files.add(file);
                            }
                        } else {
                            out = new ByteArrayOutputStream();
                        }
                        if ("base64".equalsIgnoreCase(content_transfer_encoding)) {
                            in = new Base64InputStream(in);
                        } else if ("quoted-printable".equalsIgnoreCase(content_transfer_encoding)) {
                            in = new FilterInputStream(in){

                                public int read() throws IOException {
                                    int c = this.in.read();
                                    if (c >= 0 && c == 61) {
                                        int hi = this.in.read();
                                        int lo = this.in.read();
                                        if (hi < 0 || lo < 0) {
                                            throw new IOException("Unexpected end to quoted-printable byte");
                                        }
                                        char[] chars = new char[]{(char)hi, (char)lo};
                                        c = Integer.parseInt(new String(chars), 16);
                                    }
                                    return c;
                                }
                            };
                        }
                        int state = -2;
                        boolean cr = false;
                        boolean lf = false;
                        while (true) {
                            int c;
                            int b = 0;
                            while ((c = state != -2 ? state : in.read()) != -1) {
                                state = -2;
                                if (c == 13 || c == 10) {
                                    if (c != 13) break;
                                    state = in.read();
                                    break;
                                }
                                if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                                    ++b;
                                    continue;
                                }
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                if (b > 0) {
                                    out.write(byteBoundary, 0, b);
                                }
                                b = -1;
                                out.write(c);
                            }
                            if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                                if (cr) {
                                    out.write(13);
                                }
                                if (lf) {
                                    out.write(10);
                                }
                                lf = false;
                                cr = false;
                                out.write(byteBoundary, 0, b);
                                b = -1;
                            }
                            if (b > 0 || c == -1) {
                                if (b == byteBoundary.length) {
                                    lastPart = true;
                                }
                                if (state == 10) {
                                    state = -2;
                                }
                                break;
                            }
                            if (cr) {
                                out.write(13);
                            }
                            if (lf) {
                                out.write(10);
                            }
                            cr = c == 13;
                            boolean bl = lf = c == 10 || state == 10;
                            if (state != 10) continue;
                            state = -2;
                        }
                    }
                    finally {
                        out.close();
                    }
                    if (file != null) continue block7;
                    bytes = ((ByteArrayOutputStream)out).toByteArray();
                    params.add(name, bytes);
                    continue block7;
                }
                break block7;
            }
            chain.doFilter((ServletRequest)new Wrapper(srequest, params), response);
        }
        finally {
            this.deleteFiles(request);
        }
    }

    private void deleteFiles(ServletRequest request) {
        ArrayList files = (ArrayList)request.getAttribute(FILES);
        if (files != null) {
            for (File file : files) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    this._context.log("failed to delete " + file, (Throwable)e);
                }
            }
        }
    }

    private String value(String nameEqualsValue) {
        return nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
    }

    public void destroy() {
    }

    private static class Base64InputStream
    extends InputStream {
        BufferedReader _in;
        String _line;
        byte[] _buffer;
        int _pos;

        public Base64InputStream(InputStream in) {
            this._in = new BufferedReader(new InputStreamReader(in));
        }

        public int read() throws IOException {
            if (this._buffer == null || this._pos >= this._buffer.length) {
                this._line = this._in.readLine();
                if (this._line == null) {
                    return -1;
                }
                this._buffer = this._line.startsWith("--") ? (this._line + "\r\n").getBytes() : (this._line.length() == 0 ? "\r\n".getBytes() : B64Code.decode(this._line));
                this._pos = 0;
            }
            return this._buffer[this._pos++];
        }
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        String _encoding = "UTF-8";
        MultiMap _params;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this._params = map;
        }

        public int getContentLength() {
            return 0;
        }

        public String getParameter(String name) {
            Object o = this._params.get(name);
            if (!(o instanceof byte[]) && LazyList.size(o) > 0) {
                o = LazyList.get(o, 0);
            }
            if (o instanceof byte[]) {
                try {
                    String s = new String((byte[])o, this._encoding);
                    return s;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (o != null) {
                return String.valueOf(o);
            }
            return null;
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this._params.toStringArrayMap());
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this._params.keySet());
        }

        public String[] getParameterValues(String name) {
            List<Object> l = this._params.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = new String((byte[])o, this._encoding);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this._encoding = enc;
        }
    }
}

