/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import org.fest.assertions.description.Description;
import org.fest.assertions.error.AssertionErrorFactory;
import org.fest.assertions.error.ConstructorInvoker;
import org.fest.assertions.error.DescriptionFormatter;
import org.fest.assertions.error.MessageFormatter;
import org.fest.assertions.internal.Failures;
import org.fest.util.Arrays;
import org.fest.util.ComparatorBasedComparisonStrategy;
import org.fest.util.ComparisonStrategy;
import org.fest.util.Objects;
import org.fest.util.StandardComparisonStrategy;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

public class ShouldBeEqual
implements AssertionErrorFactory {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "expected:\n<%s>\n but was:\n<%s>";
    private static final String EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR = "Expecting actual:\n<%s>\n to be equal to \n<%s>\n%s but was not.";
    private static final Class<?>[] MSG_ARG_TYPES = new Class[]{String.class, String.class, String.class};
    @VisibleForTesting
    ConstructorInvoker constructorInvoker = new ConstructorInvoker();
    @VisibleForTesting
    MessageFormatter messageFormatter = MessageFormatter.instance();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();
    protected final Object actual;
    protected final Object expected;
    private ComparisonStrategy comparisonStrategy;

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected) {
        return new ShouldBeEqual(actual, expected, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeEqual(actual, expected, comparisonStrategy);
    }

    @VisibleForTesting
    ShouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        this.actual = actual;
        this.expected = expected;
        this.comparisonStrategy = comparisonStrategy;
    }

    public AssertionError newAssertionError(Description description) {
        AssertionError error;
        if (this.actualAndExpectedHaveSameStringRepresentation()) {
            return Failures.instance().failure(this.defaultDetailedErrorMessage(description));
        }
        if (this.isJUnitComparisonFailureRelevant() && (error = this.comparisonFailure(description)) != null) {
            return error;
        }
        return Failures.instance().failure(this.defaultErrorMessage(description));
    }

    private boolean isJUnitComparisonFailureRelevant() {
        return !(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy);
    }

    private boolean actualAndExpectedHaveSameStringRepresentation() {
        return Objects.areEqual((Object)ToString.toStringOf((Object)this.actual), (Object)ToString.toStringOf((Object)this.expected));
    }

    private String defaultErrorMessage(Description description) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.actual, this.expected, this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE, this.expected, this.actual);
    }

    private String defaultDetailedErrorMessage(Description description) {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.detailedActual(), this.detailedExpected(), this.comparisonStrategy);
        }
        return this.messageFormatter.format(description, EXPECTED_BUT_WAS_MESSAGE, this.detailedExpected(), this.detailedActual());
    }

    private AssertionError comparisonFailure(Description description) {
        try {
            AssertionError comparisonFailure = this.newComparisonFailure(this.descriptionFormatter.format(description).trim());
            Failures.instance().removeFestRelatedElementsFromStackTraceIfNeeded(comparisonFailure);
            return comparisonFailure;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError newComparisonFailure(String description) throws Exception {
        Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES, this.msgArgs(description));
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private Object[] msgArgs(String description) {
        return Arrays.array((Object[])new String[]{description, ToString.toStringOf((Object)this.expected), ToString.toStringOf((Object)this.actual)});
    }

    private static String detailedToStringOf(Object obj) {
        return ToString.toStringOf((Object)obj) + " (" + obj.getClass().getSimpleName() + "@" + Integer.toHexString(obj.hashCode()) + ")";
    }

    private String detailedActual() {
        return ShouldBeEqual.detailedToStringOf(this.actual);
    }

    private String detailedExpected() {
        return ShouldBeEqual.detailedToStringOf(this.expected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShouldBeEqual other = (ShouldBeEqual)o;
        if (!Objects.areEqual((Object)this.actual, (Object)other.actual)) {
            return false;
        }
        return Objects.areEqual((Object)this.expected, (Object)other.expected);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor((Object)this.actual);
        result = 31 * result + Objects.hashCodeFor((Object)this.expected);
        return result;
    }
}

