/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasZeroPadding3D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasZeroPadding3D.class);

    public KerasZeroPadding3D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasZeroPadding3D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        String paddingField = this.conf.getLAYER_FIELD_ZERO_PADDING();
        int[] padding = KerasConvolutionUtils.getPaddingFromConfig(layerConfig, this.conf, paddingField, 3);
        ZeroPadding3DLayer.Builder builder = (ZeroPadding3DLayer.Builder)((ZeroPadding3DLayer.Builder)new ZeroPadding3DLayer.Builder(padding).name(this.layerName)).dropOut(this.dropout);
        this.layer = builder.build();
        this.vertex = null;
    }

    public ZeroPadding3DLayer getZeroPadding3DLayer() {
        return (ZeroPadding3DLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras ZeroPadding3D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getZeroPadding3DLayer().getOutputType(-1, inputType[0]);
    }

    public String toString() {
        return "KerasZeroPadding3D()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasZeroPadding3D)) {
            return false;
        }
        KerasZeroPadding3D other = (KerasZeroPadding3D)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasZeroPadding3D;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

