/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class TimeColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final Long value;
    private final Set<Long> set;

    public TimeColumnCondition(String columnName, ConditionOp op, long value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public TimeColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, long value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public TimeColumnCondition(String column, ConditionOp op, Set<Long> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public TimeColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Long> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    private TimeColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") long value, @JsonProperty(value="set") Set<Long> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = set == null ? Long.valueOf(value) : null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return this.op.apply(writable.toLong(), this.value == null ? 0L : this.value, this.set);
    }

    @Override
    public String toString() {
        return "TimeColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean condition(Object input) {
        Number n = (Number)input;
        return this.op.apply(n.longValue(), this.value == null ? 0L : this.value, this.set);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeColumnCondition)) {
            return false;
        }
        TimeColumnCondition other = (TimeColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.getOp();
        ConditionOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Set<Long> this$set = this.getSet();
        Set<Long> other$set = other.getSet();
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConditionOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Set<Long> $set = this.getSet();
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }

    public ConditionOp getOp() {
        return this.op;
    }

    public Long getValue() {
        return this.value;
    }

    public Set<Long> getSet() {
        return this.set;
    }
}

