/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.inmemory;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class InMemorySequenceRecordReader
implements SequenceRecordReader {
    private List<List<List<Writable>>> records;
    private Iterator<List<List<Writable>>> iter;
    private List<String> labels;
    private List<RecordListener> recordListeners;
    private Configuration configuration;

    public InMemorySequenceRecordReader(List<List<List<Writable>>> records) {
        this.records = records;
        this.iter = records.iterator();
    }

    @Override
    public void setConf(Configuration conf) {
        this.configuration = conf;
    }

    @Override
    public Configuration getConf() {
        return this.configuration;
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.iter.next();
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<List<Writable>> next(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SequenceRecord nextSequence() {
        return new org.datavec.api.records.impl.SequenceRecord(this.sequenceRecord(), null);
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public List<Writable> next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public void reset() {
        this.iter = this.records.iterator();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return null;
    }

    @Override
    public Record nextRecord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.recordListeners;
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.recordListeners = Arrays.asList(listeners);
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.recordListeners = new ArrayList<RecordListener>(listeners);
    }

    @Override
    public void close() throws IOException {
    }

    public List<List<List<Writable>>> getRecords() {
        return this.records;
    }

    public Iterator<List<List<Writable>>> getIter() {
        return this.iter;
    }

    public List<RecordListener> getRecordListeners() {
        return this.recordListeners;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setRecords(List<List<List<Writable>>> records) {
        this.records = records;
    }

    public void setIter(Iterator<List<List<Writable>>> iter) {
        this.iter = iter;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setRecordListeners(List<RecordListener> recordListeners) {
        this.recordListeners = recordListeners;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InMemorySequenceRecordReader)) {
            return false;
        }
        InMemorySequenceRecordReader other = (InMemorySequenceRecordReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<List<Writable>>> this$records = this.getRecords();
        List<List<List<Writable>>> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Iterator<List<List<Writable>>> this$iter = this.getIter();
        Iterator<List<List<Writable>>> other$iter = other.getIter();
        if (this$iter == null ? other$iter != null : !this$iter.equals(other$iter)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<RecordListener> this$recordListeners = this.getRecordListeners();
        List<RecordListener> other$recordListeners = other.getRecordListeners();
        if (this$recordListeners == null ? other$recordListeners != null : !((Object)this$recordListeners).equals(other$recordListeners)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InMemorySequenceRecordReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<List<Writable>>> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Iterator<List<List<Writable>>> $iter = this.getIter();
        result = result * 59 + ($iter == null ? 43 : $iter.hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<RecordListener> $recordListeners = this.getRecordListeners();
        result = result * 59 + ($recordListeners == null ? 43 : ((Object)$recordListeners).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public String toString() {
        return "InMemorySequenceRecordReader(records=" + this.getRecords() + ", iter=" + this.getIter() + ", labels=" + this.getLabels() + ", recordListeners=" + this.getRecordListeners() + ", configuration=" + this.getConfiguration() + ")";
    }
}

