/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;
import org.datavec.api.writable.Writable;

public class CSVLineSequenceRecordReader
extends CSVRecordReader
implements SequenceRecordReader {
    public CSVLineSequenceRecordReader() {
        this(0, ',', '\"');
    }

    public CSVLineSequenceRecordReader(int skipNumLines, char delimiter) {
        this(skipNumLines, delimiter, '\"');
    }

    public CSVLineSequenceRecordReader(int skipNumLines, char delimiter, char quote) {
        super(skipNumLines, delimiter, quote);
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.nextSequence().getSequenceRecord();
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        List<Writable> l = this.record(uri, dataInputStream);
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (Writable w : l) {
            out.add(Collections.singletonList(w));
        }
        return out;
    }

    @Override
    public SequenceRecord nextSequence() {
        return this.convert(super.nextRecord());
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.convert(super.loadFromMetaData(recordMetaData));
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        List<Record> toConvert = super.loadFromMetaData(recordMetaDatas);
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (Record r : toConvert) {
            out.add(this.convert(r));
        }
        return out;
    }

    protected SequenceRecord convert(Record r) {
        List<Writable> line = r.getRecord();
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (Writable w : line) {
            out.add(Collections.singletonList(w));
        }
        return new org.datavec.api.records.impl.SequenceRecord(out, r.getMetaData());
    }
}

