/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ui.components;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ui.components.RenderableComponent;

public class RenderableComponentHistogram
extends RenderableComponent {
    public static final String COMPONENT_TYPE = "histogram";
    private String title;
    private List<Double> lowerBounds = new ArrayList<Double>();
    private List<Double> upperBounds = new ArrayList<Double>();
    private List<Double> yValues = new ArrayList<Double>();
    private int marginTop;
    private int marginBottom;
    private int marginLeft;
    private int marginRight;

    public RenderableComponentHistogram(Builder builder) {
        super(COMPONENT_TYPE);
        this.title = builder.title;
        this.lowerBounds = builder.lowerBounds;
        this.upperBounds = builder.upperBounds;
        this.yValues = builder.yValues;
        this.marginTop = builder.marginTop;
        this.marginBottom = builder.marginBottom;
        this.marginLeft = builder.marginLeft;
        this.marginRight = builder.marginRight;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderableComponentHistogram)) {
            return false;
        }
        RenderableComponentHistogram other = (RenderableComponentHistogram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMarginTop() != other.getMarginTop()) {
            return false;
        }
        if (this.getMarginBottom() != other.getMarginBottom()) {
            return false;
        }
        if (this.getMarginLeft() != other.getMarginLeft()) {
            return false;
        }
        if (this.getMarginRight() != other.getMarginRight()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<Double> this$lowerBounds = this.getLowerBounds();
        List<Double> other$lowerBounds = other.getLowerBounds();
        if (this$lowerBounds == null ? other$lowerBounds != null : !((Object)this$lowerBounds).equals(other$lowerBounds)) {
            return false;
        }
        List<Double> this$upperBounds = this.getUpperBounds();
        List<Double> other$upperBounds = other.getUpperBounds();
        if (this$upperBounds == null ? other$upperBounds != null : !((Object)this$upperBounds).equals(other$upperBounds)) {
            return false;
        }
        List<Double> this$yValues = this.getYValues();
        List<Double> other$yValues = other.getYValues();
        return !(this$yValues == null ? other$yValues != null : !((Object)this$yValues).equals(other$yValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RenderableComponentHistogram;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMarginTop();
        result = result * 59 + this.getMarginBottom();
        result = result * 59 + this.getMarginLeft();
        result = result * 59 + this.getMarginRight();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<Double> $lowerBounds = this.getLowerBounds();
        result = result * 59 + ($lowerBounds == null ? 43 : ((Object)$lowerBounds).hashCode());
        List<Double> $upperBounds = this.getUpperBounds();
        result = result * 59 + ($upperBounds == null ? 43 : ((Object)$upperBounds).hashCode());
        List<Double> $yValues = this.getYValues();
        result = result * 59 + ($yValues == null ? 43 : ((Object)$yValues).hashCode());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Double> getLowerBounds() {
        return this.lowerBounds;
    }

    public List<Double> getUpperBounds() {
        return this.upperBounds;
    }

    public List<Double> getYValues() {
        return this.yValues;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLowerBounds(List<Double> lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public void setUpperBounds(List<Double> upperBounds) {
        this.upperBounds = upperBounds;
    }

    public void setYValues(List<Double> yValues) {
        this.yValues = yValues;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    @Override
    public String toString() {
        return "RenderableComponentHistogram(title=" + this.getTitle() + ", lowerBounds=" + this.getLowerBounds() + ", upperBounds=" + this.getUpperBounds() + ", yValues=" + this.getYValues() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ")";
    }

    public static class Builder {
        private String title;
        private List<Double> lowerBounds = new ArrayList<Double>();
        private List<Double> upperBounds = new ArrayList<Double>();
        private List<Double> yValues = new ArrayList<Double>();
        private int marginTop = 60;
        private int marginBottom = 60;
        private int marginLeft = 60;
        private int marginRight = 20;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder addBin(double lower, double upper, double yValue) {
            this.lowerBounds.add(lower);
            this.upperBounds.add(upper);
            this.yValues.add(yValue);
            return this;
        }

        public Builder margins(int top, int bottom, int left, int right) {
            this.marginTop = top;
            this.marginBottom = bottom;
            this.marginLeft = left;
            this.marginRight = right;
            return this;
        }

        public RenderableComponentHistogram build() {
            return new RenderableComponentHistogram(this);
        }
    }
}

