/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "map", "columnIdx"})
public class StringListToCategoricalSetTransform
extends BaseTransform {
    private final String columnName;
    private final List<String> newColumnNames;
    private final List<String> categoryTokens;
    private final String delimiter;
    private final Map<String, Integer> map;
    private int columnIdx = -1;

    public StringListToCategoricalSetTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnNames") List<String> newColumnNames, @JsonProperty(value="categoryTokens") List<String> categoryTokens, @JsonProperty(value="delimiter") String delimiter) {
        if (newColumnNames.size() != categoryTokens.size()) {
            throw new IllegalArgumentException("Names/tokens sizes cannot differ");
        }
        this.columnName = columnName;
        this.newColumnNames = newColumnNames;
        this.categoryTokens = categoryTokens;
        this.delimiter = delimiter;
        this.map = new HashMap<String, Integer>();
        for (int i = 0; i < categoryTokens.size(); ++i) {
            this.map.put(categoryTokens.get(i), i);
        }
    }

    @Override
    public Schema transform(Schema inputSchema) {
        int colIdx = inputSchema.getIndexOfColumn(this.columnName);
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size() + this.newColumnNames.size() - 1);
        List<String> oldNames = inputSchema.getColumnNames();
        Iterator<ColumnMetaData> typesIter = oldMeta.iterator();
        Iterator<String> namesIter = oldNames.iterator();
        int i = 0;
        while (typesIter.hasNext()) {
            ColumnMetaData t = typesIter.next();
            String name = namesIter.next();
            if (i++ == colIdx) {
                if (t.getColumnType() != ColumnType.String) {
                    throw new IllegalStateException("Cannot convert non-string type");
                }
                for (int j = 0; j < this.newColumnNames.size(); ++j) {
                    CategoricalMetaData meta = new CategoricalMetaData(this.newColumnNames.get(j), "true", "false");
                    newMeta.add(meta);
                }
                continue;
            }
            newMeta.add(t);
        }
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.columnIdx = inputSchema.getIndexOfColumn(this.columnName);
    }

    @Override
    public String toString() {
        return "StringListToCategoricalSetTransform(columnName=" + this.columnName + ",newColumnNames=" + this.newColumnNames + ",categoryTokens=" + this.categoryTokens + ",delimiter=\"" + this.delimiter + "\")";
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int n = writables.size();
        ArrayList<Writable> out = new ArrayList<Writable>(n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == this.columnIdx) {
                String str = w.toString();
                boolean[] present = new boolean[this.categoryTokens.size()];
                if (str != null && !str.isEmpty()) {
                    String[] split;
                    for (String s : split = str.split(this.delimiter)) {
                        Integer idx = this.map.get(s);
                        if (idx == null) {
                            throw new IllegalStateException("Encountered unknown String: \"" + s + "\"");
                        }
                        present[idx.intValue()] = true;
                    }
                }
                for (int j = 0; j < present.length; ++j) {
                    out.add(new Text(present[j] ? "true" : "false"));
                }
                continue;
            }
            out.add(w);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        return null;
    }

    @Override
    public Object mapSequence(Object sequence) {
        return null;
    }

    @Override
    public String outputColumnName() {
        throw new UnsupportedOperationException("New column names is always more than 1 in length");
    }

    @Override
    public String[] outputColumnNames() {
        return this.newColumnNames.toArray(new String[this.newColumnNames.size()]);
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringListToCategoricalSetTransform)) {
            return false;
        }
        StringListToCategoricalSetTransform other = (StringListToCategoricalSetTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        List<String> this$newColumnNames = this.getNewColumnNames();
        List<String> other$newColumnNames = other.getNewColumnNames();
        if (this$newColumnNames == null ? other$newColumnNames != null : !((Object)this$newColumnNames).equals(other$newColumnNames)) {
            return false;
        }
        List<String> this$categoryTokens = this.getCategoryTokens();
        List<String> other$categoryTokens = other.getCategoryTokens();
        if (this$categoryTokens == null ? other$categoryTokens != null : !((Object)this$categoryTokens).equals(other$categoryTokens)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
            return false;
        }
        Map<String, Integer> this$map = this.getMap();
        Map<String, Integer> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringListToCategoricalSetTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        List<String> $newColumnNames = this.getNewColumnNames();
        result = result * 59 + ($newColumnNames == null ? 43 : ((Object)$newColumnNames).hashCode());
        List<String> $categoryTokens = this.getCategoryTokens();
        result = result * 59 + ($categoryTokens == null ? 43 : ((Object)$categoryTokens).hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        Map<String, Integer> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<String> getNewColumnNames() {
        return this.newColumnNames;
    }

    public List<String> getCategoryTokens() {
        return this.categoryTokens;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Map<String, Integer> getMap() {
        return this.map;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }
}

