/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.Map;
import org.datavec.api.transform.transform.string.BaseStringTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ReplaceStringTransform
extends BaseStringTransform {
    private final Map<String, String> map;

    public ReplaceStringTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="map") Map<String, String> map) {
        super(columnName);
        this.map = map;
    }

    @Override
    public Text map(Writable writable) {
        String value = writable.toString();
        value = this.replaceAll(value);
        return new Text(value);
    }

    @Override
    public Object map(Object o) {
        String value = o.toString();
        value = this.replaceAll(value);
        return value;
    }

    private String replaceAll(String value) {
        if (this.map != null && !this.map.isEmpty()) {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                value = value.replaceAll(entry.getKey(), entry.getValue());
            }
        }
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringTransform)) {
            return false;
        }
        ReplaceStringTransform other = (ReplaceStringTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$map = this.getMap();
        Map<String, String> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceStringTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public String toString() {
        return "ReplaceStringTransform(map=" + this.getMap() + ")";
    }
}

