/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class ConcatenateStringColumns
extends BaseTransform
implements ColumnOp {
    private final String newColumnName;
    private final String delimiter;
    private final List<String> columnsToConcatenate;
    private Schema inputSchema;

    public ConcatenateStringColumns(String newColumnName, String delimiter, String ... columnsToConcatenate) {
        this(newColumnName, delimiter, Arrays.asList(columnsToConcatenate));
    }

    public ConcatenateStringColumns(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="columnsToConcatenate") List<String> columnsToConcatenate) {
        this.newColumnName = newColumnName;
        this.delimiter = delimiter;
        this.columnsToConcatenate = columnsToConcatenate;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        for (String s : this.columnsToConcatenate) {
            if (inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Input schema does not contain column with name \"" + s + "\"");
        }
        ArrayList<ColumnMetaData> outMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        ColumnMetaData newColMeta = ColumnType.String.newColumnMetaData(this.newColumnName);
        outMeta.add(newColMeta);
        return inputSchema.newSchema(outMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        for (String s : this.columnsToConcatenate) {
            if (inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Input schema does not contain column with name \"" + s + "\"");
        }
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        StringBuilder newColumnText = new StringBuilder();
        ArrayList<Writable> out = new ArrayList<Writable>(writables);
        int i = 0;
        for (String columnName : this.columnsToConcatenate) {
            if (i++ > 0) {
                newColumnText.append(this.delimiter);
            }
            int columnIdx = this.inputSchema.getIndexOfColumn(columnName);
            newColumnText.append(writables.get(columnIdx));
        }
        out.add(new Text(newColumnText.toString()));
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcatenateStringColumns o2 = (ConcatenateStringColumns)o;
        return this.delimiter.equals(o2.delimiter) && this.columnsToConcatenate.equals(o2.columnsToConcatenate);
    }

    @Override
    public int hashCode() {
        int result = this.delimiter.hashCode();
        result = 31 * result + this.columnsToConcatenate.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ConcatenateStringColumns(delimiters=" + this.delimiter + " columnsToConcatenate=" + this.columnsToConcatenate + ")";
    }

    @Override
    public String outputColumnName() {
        return this.newColumnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.newColumnName};
    }

    @Override
    public String[] columnNames() {
        return this.columnsToConcatenate.toArray(new String[this.getInputSchema().getColumnNames().size()]);
    }

    @Override
    public String columnName() {
        return this.columnsToConcatenate.get(0);
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public List<String> getColumnsToConcatenate() {
        return this.columnsToConcatenate;
    }
}

