/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.string;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import java.io.Serializable;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.quality.columns.StringQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.common.function.BiFunction;

public class StringQualityAddFunction
implements BiFunction<StringQuality, Writable, StringQuality>,
Serializable {
    private final StringMetaData meta;

    public StringQuality apply(StringQuality v1, Writable writable) {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        long empty = v1.getCountEmptyString();
        long alphabetic = v1.getCountAlphabetic();
        long numerical = v1.getCountNumerical();
        long word = v1.getCountWordCharacter();
        long whitespaceOnly = v1.getCountWhitespace();
        HyperLogLogPlus hll = v1.getHll();
        String str = writable.toString();
        if (writable instanceof NullWritable) {
            ++countMissing;
        } else if (this.meta.isValid(writable)) {
            ++valid;
        } else {
            ++invalid;
        }
        if (str == null || str.isEmpty()) {
            ++empty;
        } else {
            if (str.matches("[a-zA-Z]")) {
                ++alphabetic;
            }
            if (str.matches("\\d+")) {
                ++numerical;
            }
            if (str.matches("\\w+")) {
                ++word;
            }
            if (str.matches("\\s+")) {
                ++whitespaceOnly;
            }
        }
        hll.offer((Object)str);
        return new StringQuality(valid, invalid, countMissing, countTotal, empty, alphabetic, numerical, word, whitespaceOnly, hll);
    }

    public StringQualityAddFunction(StringMetaData meta) {
        this.meta = meta;
    }
}

