/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataLineInterval;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class CSVVariableSlidingWindowRecordReader
extends CSVRecordReader
implements SequenceRecordReader {
    public static final String LINES_PER_SEQUENCE = NAME_SPACE + ".nlinespersequence";
    private int maxLinesPerSequence;
    private String delimiter;
    private int stride;
    private LinkedList<List<Writable>> queue;
    private boolean exhausted;

    public CSVVariableSlidingWindowRecordReader() {
        this(10, 1);
    }

    public CSVVariableSlidingWindowRecordReader(int maxLinesPerSequence) {
        this(maxLinesPerSequence, 0, 1, String.valueOf(','));
    }

    public CSVVariableSlidingWindowRecordReader(int maxLinesPerSequence, int stride) {
        this(maxLinesPerSequence, 0, stride, String.valueOf(','));
    }

    public CSVVariableSlidingWindowRecordReader(int maxLinesPerSequence, int stride, String delimiter) {
        this(maxLinesPerSequence, 0, stride, String.valueOf(','));
    }

    public CSVVariableSlidingWindowRecordReader(int maxLinesPerSequence, int skipNumLines, int stride, String delimiter) {
        super(skipNumLines);
        if (stride < 1) {
            throw new IllegalArgumentException("Stride must be greater than 1");
        }
        this.delimiter = delimiter;
        this.maxLinesPerSequence = maxLinesPerSequence;
        this.stride = stride;
        this.queue = new LinkedList();
        this.exhausted = false;
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.maxLinesPerSequence = conf.getInt(LINES_PER_SEQUENCE, this.maxLinesPerSequence);
    }

    @Override
    public boolean hasNext() {
        boolean moreInCsv = super.hasNext();
        boolean moreInQueue = !this.queue.isEmpty();
        return moreInCsv || moreInQueue;
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        for (int i = 0; i < this.stride; ++i) {
            if (super.hasNext()) {
                this.queue.addFirst(super.next());
            } else {
                this.exhausted = true;
            }
            if (this.exhausted && this.queue.size() < 1) {
                throw new NoSuchElementException("No next element");
            }
            if (this.queue.size() <= this.maxLinesPerSequence && !this.exhausted) continue;
            this.queue.pollLast();
        }
        ArrayList<List<Writable>> sequence = new ArrayList<List<Writable>>();
        sequence.addAll(this.queue);
        if (this.exhausted && this.queue.size() == 1) {
            this.queue.pollLast();
        }
        return sequence;
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading CSV data from DataInputStream not yet implemented");
    }

    @Override
    public SequenceRecord nextSequence() {
        int lineBefore = this.lineIndex;
        List<List<Writable>> record = this.sequenceRecord();
        int lineAfter = this.lineIndex + this.queue.size();
        URI uri = this.locations == null || this.locations.length < 1 ? null : this.locations[this.splitIndex];
        RecordMetaDataLineInterval meta = new RecordMetaDataLineInterval(lineBefore, lineAfter - 1, uri, CSVVariableSlidingWindowRecordReader.class);
        return new org.datavec.api.records.impl.SequenceRecord(record, meta);
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void reset() {
        super.reset();
        this.queue = new LinkedList();
        this.exhausted = false;
    }
}

