/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataInterval;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;
import org.datavec.api.writable.Writable;
import org.nd4j.common.base.Preconditions;

public class CSVMultiSequenceRecordReader
extends CSVRecordReader
implements SequenceRecordReader {
    private String sequenceSeparatorRegex;
    private Mode mode;
    private Writable padValue;

    public CSVMultiSequenceRecordReader(String sequenceSeparatorRegex, Mode mode) {
        this(0, ',', '\"', sequenceSeparatorRegex, mode, null);
    }

    public CSVMultiSequenceRecordReader(String sequenceSeparatorRegex, Mode mode, Writable padValue) {
        this(0, ',', '\"', sequenceSeparatorRegex, mode, padValue);
    }

    public CSVMultiSequenceRecordReader(int skipNumLines, char elementDelimiter, char quote, String sequenceSeparatorRegex, Mode mode, Writable padValue) {
        super(skipNumLines, elementDelimiter, quote);
        Preconditions.checkState((mode != Mode.PAD || padValue != null ? 1 : 0) != 0, (String)"Cannot use Mode.PAD with a null padding value. Padding value must be passed to constructor ");
        this.sequenceSeparatorRegex = sequenceSeparatorRegex;
        this.mode = mode;
        this.padValue = padValue;
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.nextSequence().getSequenceRecord();
    }

    @Override
    public SequenceRecord nextSequence() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        ArrayList<String> lines = new ArrayList<String>();
        int firstLine = this.lineIndex;
        int lastLine = this.lineIndex;
        while (super.hasNext()) {
            String line = this.readStringLine();
            if (line.matches(this.sequenceSeparatorRegex)) {
                lastLine = this.lineIndex;
                break;
            }
            lines.add(line);
        }
        URI uri = this.locations == null || this.locations.length < 1 ? null : this.locations[this.splitIndex];
        List<List<Writable>> out = this.parseLines(lines, uri, firstLine, lastLine);
        return new org.datavec.api.records.impl.SequenceRecord(out, new RecordMetaDataInterval(firstLine, lastLine, uri));
    }

    private List<List<Writable>> parseLines(List<String> lines, URI uri, int firstLine, int lastLine) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        switch (this.mode) {
            case CONCAT: {
                for (String s : lines) {
                    List<Writable> parsed = super.parseLine(s);
                    for (Writable writable : parsed) {
                        out.add(Collections.singletonList(writable));
                    }
                }
                break;
            }
            case EQUAL_LENGTH: 
            case PAD: {
                ArrayList<List<Writable>> columnWise = new ArrayList<List<Writable>>();
                int length = -1;
                int lineNum = 0;
                for (String string : lines) {
                    List<Writable> parsed = super.parseLine(string);
                    columnWise.add(parsed);
                    ++lineNum;
                    if (this.mode == Mode.PAD) {
                        length = Math.max(length, parsed.size());
                        continue;
                    }
                    if (length < 0) {
                        length = parsed.size();
                        continue;
                    }
                    if (this.mode != Mode.EQUAL_LENGTH) continue;
                    Preconditions.checkState((parsed.size() == length ? 1 : 0) != 0, (String)("Invalid state: When using CSVMultiSequenceRecordReader, all lines (columns) must be the same length. Prior columns had " + length + " elements, line " + lineNum + " in sequence has length " + parsed.size() + " (Sequence position: " + uri + ", lines " + firstLine + " to " + lastLine + ")"));
                }
                if (this.mode == Mode.PAD) {
                    for (List list : columnWise) {
                        while (list.size() < length) {
                            list.add(this.padValue);
                        }
                    }
                }
                for (int i = 0; i < length; ++i) {
                    ArrayList<Writable> arrayList = new ArrayList<Writable>();
                    for (int j = 0; j < columnWise.size(); ++j) {
                        arrayList.add((Writable)((List)columnWise.get(j)).get(i));
                    }
                    out.add(arrayList);
                }
                break;
            }
        }
        return out;
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));){
            String line;
            while ((line = br.readLine()) != null && !line.matches(this.sequenceSeparatorRegex)) {
                lines.add(line);
            }
        }
        return this.parseLines(lines, uri, 0, lines.size());
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    public static enum Mode {
        CONCAT,
        EQUAL_LENGTH,
        PAD;

    }
}

