/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.collection;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataIndex;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class CollectionRecordReader
extends BaseRecordReader {
    private Iterator<? extends Collection<Writable>> records;
    private final Collection<? extends Collection<Writable>> original;
    private int count = 0;

    public CollectionRecordReader(Collection<? extends Collection<Writable>> records) {
        this.records = records.iterator();
        this.original = records;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public List<Writable> next() {
        Collection<Writable> next = this.records.next();
        List<Object> record = next instanceof List ? (List<Object>)next : new ArrayList<Writable>(next);
        this.invokeListeners(record);
        ++this.count;
        return record;
    }

    @Override
    public boolean hasNext() {
        return this.records.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return null;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void reset() {
        this.records = this.original.iterator();
        this.count = 0;
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Generating records from DataInputStream not supported for CollectionRecordReader");
    }

    @Override
    public Record nextRecord() {
        return new org.datavec.api.records.impl.Record(this.next(), new RecordMetaDataIndex(this.count - 1, null, CollectionRecordReader.class));
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        HashSet<Integer> toLoad = new HashSet<Integer>();
        for (RecordMetaData recordMetaData : recordMetaDatas) {
            if (!(recordMetaData instanceof RecordMetaDataIndex)) {
                throw new IllegalArgumentException("Expected RecordMetaDataIndex; got: " + recordMetaData);
            }
            long idx = ((RecordMetaDataIndex)recordMetaData).getIndex();
            if (idx >= (long)this.original.size()) {
                throw new IllegalStateException("Cannot get index " + idx + " from collection: contains " + this.original + " elements");
            }
            toLoad.add((int)idx);
        }
        ArrayList<Record> out = new ArrayList<Record>();
        if (this.original instanceof List) {
            List asList = (List)this.original;
            for (Integer i : toLoad) {
                ArrayList<Writable> l = new ArrayList<Writable>((Collection)asList.get(i));
                org.datavec.api.records.impl.Record r = new org.datavec.api.records.impl.Record(l, new RecordMetaDataIndex(i.intValue(), null, CollectionRecordReader.class));
                out.add(r);
            }
        } else {
            Iterator<? extends Collection<Writable>> iter = this.original.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Collection<Writable> c = iter.next();
                if (!toLoad.contains(i++)) continue;
                List<Object> l = c instanceof List ? (List<Object>)c : new ArrayList<Writable>(c);
                org.datavec.api.records.impl.Record r = new org.datavec.api.records.impl.Record((List<Writable>)l, new RecordMetaDataIndex(i - 1, null, CollectionRecordReader.class));
                out.add(r);
            }
        }
        return out;
    }
}

