/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class ConcatenatingRecordReader
extends BaseRecordReader {
    private RecordReader[] readers;

    public ConcatenatingRecordReader(RecordReader ... readers) {
        this.readers = readers;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public List<Writable> next() {
        List<Writable> out = null;
        for (RecordReader rr : this.readers) {
            if (!rr.hasNext()) continue;
            out = rr.next();
            break;
        }
        this.invokeListeners(out);
        return out;
    }

    @Override
    public boolean hasNext() {
        for (RecordReader reader : this.readers) {
            if (!reader.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void close() throws IOException {
        for (RecordReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        for (RecordReader reader : this.readers) {
            reader.setConf(conf);
        }
    }

    @Override
    public Configuration getConf() {
        return this.readers[0].getConf();
    }

    @Override
    public void reset() {
        for (RecordReader reader : this.readers) {
            reader.reset();
        }
    }

    @Override
    public boolean resetSupported() {
        for (RecordReader rr : this.readers) {
            if (rr.resetSupported()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Generating records from DataInputStream not supported for ComposableRecordReader");
    }

    @Override
    public Record nextRecord() {
        return new org.datavec.api.records.impl.Record(this.next(), null);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException("Loading from metadata not yet implemented");
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException("Loading from metadata not yet implemented");
    }
}

