/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.datanucleus.maven.AbstractDataNucleusMojo;

public abstract class AbstractEnhancerMojo
extends AbstractDataNucleusMojo {
    private static final String TOOL_NAME_DATANUCLEUS_ENHANCER = "org.datanucleus.enhancer.DataNucleusEnhancer";
    protected String persistenceUnitName;
    protected String enhancerName;
    protected String api;
    private List projectArtifacts;
    private File projectOutputDirectory;
    private boolean fork = true;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected void executeDataNucleusTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        this.enhance(pluginArtifacts, files);
    }

    protected void enhance(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        ArrayList<String> cpEntries = new ArrayList<String>();
        Iterator it = pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                String artifactPath = artifact.getFile().getCanonicalPath();
                if (cpEntries.contains(artifactPath)) continue;
                cpEntries.add(artifactPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        Iterator uniqueIter = this.getUniqueClasspathElements().iterator();
        while (uniqueIter.hasNext()) {
            String entry = (String)uniqueIter.next();
            if (cpEntries.contains(entry)) continue;
            cpEntries.add(entry);
        }
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it2 = cpEntries.iterator();
        while (it2.hasNext()) {
            cpBuffer.append((String)it2.next());
            if (!it2.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(cpBuffer.toString());
        URL log4jURL = this.getLog4JConfiguration();
        if (log4jURL != null) {
            cl.createArgument().setValue("-Dlog4j.configuration=" + log4jURL);
        } else {
            URL jdkLogURL = this.getJdkLogConfiguration();
            if (jdkLogURL != null) {
                cl.createArgument().setValue("-Djava.util.logging.config.file=" + jdkLogURL);
            }
        }
        cl.createArgument().setValue(TOOL_NAME_DATANUCLEUS_ENHANCER);
        ArrayList<String> args = new ArrayList<String>();
        this.prepareModeSpecificCommandLineArguments(cl, args);
        if (this.verbose) {
            cl.createArgument().setValue("-v");
            args.add("-v");
        }
        if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
            cl.createArgument().setLine("-persistenceUnit " + this.persistenceUnitName);
            args.add("-persistenceUnit");
            args.add(this.persistenceUnitName);
        }
        cl.createArgument().setLine("-enhancerName " + this.enhancerName);
        args.add("-enhancerName");
        args.add(this.enhancerName);
        cl.createArgument().setLine("-api " + this.api);
        args.add("-api");
        args.add(this.api);
        Iterator it3 = files.iterator();
        while (it3.hasNext()) {
            File file = (File)it3.next();
            cl.createArgument().setValue(file.getAbsolutePath());
            args.add(file.getAbsolutePath());
        }
        if (this.fork) {
            this.executeCommandLine(cl);
        } else {
            this.executeInJvm(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInJvm(List args) throws MojoExecutionException {
        try {
            String artifactPath;
            Artifact artifact;
            ArrayList<String> cpEntries2 = new ArrayList<String>();
            Iterator it = this.pluginArtifacts.iterator();
            while (it.hasNext()) {
                artifact = (Artifact)it.next();
                try {
                    artifactPath = artifact.getFile().getCanonicalPath();
                    if (cpEntries2.contains(artifactPath)) continue;
                    cpEntries2.add(artifactPath);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
                }
            }
            cpEntries2.add(this.projectOutputDirectory.getCanonicalPath());
            it = this.projectArtifacts.iterator();
            while (it.hasNext()) {
                artifact = (Artifact)it.next();
                if (this.pluginArtifacts.contains(artifact)) continue;
                try {
                    artifactPath = artifact.getFile().getCanonicalPath();
                    if (cpEntries2.contains(artifactPath)) continue;
                    cpEntries2.add(artifactPath);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
                }
            }
            URL[] urls = new URL[cpEntries2.size()];
            int urlIdx = 0;
            Iterator it2 = cpEntries2.iterator();
            while (it2.hasNext()) {
                String n = it2.next().toString();
                try {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("  CP: " + n));
                    }
                    urls[urlIdx++] = new File(n).toURI().toURL();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Cannot convert to url: " + n, e);
                }
            }
            URLClassLoader loader = new URLClassLoader(urls, null);
            Class<?> c = loader.loadClass(TOOL_NAME_DATANUCLEUS_ENHANCER);
            Method m = c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractEnhancerMojo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            ClassLoader tl = Thread.currentThread().getContextClassLoader();
            String oldProp = System.getProperty("log4j.configuration");
            try {
                Thread.currentThread().setContextClassLoader(loader);
                URL log4jURL = this.getLog4JConfiguration();
                if (log4jURL != null) {
                    System.setProperty("log4j.configuration", log4jURL.toString());
                } else {
                    URL jdkLogURL = this.getJdkLogConfiguration();
                    if (jdkLogURL != null) {
                        System.setProperty("java.util.logging.config.file", jdkLogURL.toString());
                    }
                }
                m.invoke(null, new Object[]{args.toArray(new String[args.size()])});
            }
            finally {
                Thread.currentThread().setContextClassLoader(tl);
                if (oldProp != null) {
                    System.setProperty("log4j.configuration", oldProp);
                } else {
                    ((Hashtable)System.getProperties()).remove("log4j.configuration");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing enhancer", e);
        }
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1, List var2);

    protected String getToolName() {
        return TOOL_NAME_DATANUCLEUS_ENHANCER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

