/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.Localiser;

public final class MappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    private MappingFactory() {
    }

    protected static JavaTypeMapping createMapping(Class mappingClass, MappedStoreManager storeMgr, String type) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), e).setFatal();
        }
        mapping.initialize(storeMgr, type);
        return mapping;
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, AbstractMemberMetaData mmd, int roleForField, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), e).setFatal();
        }
        if (roleForField >= 0) {
            mapping.setRoleForMember(roleForField);
        }
        mapping.initialize(mmd, datastoreContainer, clr);
        return mapping;
    }
}

