/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.Hash;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class HashesDeserializer
extends JsonDeserializer<List<Hash>> {
    public List<Hash> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return this.parseHashes(node.has("hash") ? node.get("hash") : node);
    }

    private List<Hash> parseHashes(JsonNode node) {
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, null);
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        for (JsonNode hashNode : nodes) {
            hashes.add(this.parseHash(hashNode));
        }
        return hashes;
    }

    private Hash parseHash(JsonNode node) {
        String alg;
        String string = alg = node.has("alg") ? node.get("alg").asText() : null;
        String value = node.has("content") ? node.get("content").asText() : (node.has("") ? node.get("").asText() : null);
        return new Hash(alg, value);
    }
}

