/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class CycloneDxSchema {
    private static final Logger LOGGER = Logger.getLogger(CycloneDxSchema.class.getName());
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_DEPENDENCY_GRAPH_10 = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    public static final String NS_VULNERABILITY_10 = "http://cyclonedx.org/schema/ext/vulnerability/1.0";

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        return this.getXmlSchema11();
    }

    private Schema getXmlSchema10() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"));
    }

    private Schema getXmlSchema11() throws SAXException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        streams.add(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"));
        streams.add(this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"));
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("ext");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                streams.add(url.openStream());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "An error occurred attempting to load schema extensions", e);
        }
        return this.getXmlSchema(streams.toArray(new InputStream[0]));
    }

    public Schema getXmlSchema(InputStream ... inputStreams) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            schemaFiles[i] = new StreamSource(inputStreams[i]);
        }
        return schemaFactory.newSchema(schemaFiles);
    }

    public static enum Version {
        VERSION_10("http://cyclonedx.org/schema/bom/1.0", "1.0"),
        VERSION_11("http://cyclonedx.org/schema/bom/1.1", "1.1");

        private String namespace;
        private String versionString;

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersionString() {
            return this.versionString;
        }

        private Version(String namespace, String versionString) {
            this.namespace = namespace;
            this.versionString = versionString;
        }
    }
}

