/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators;

import org.cyclonedx.Format;
import org.cyclonedx.Version;
import org.cyclonedx.generators.AbstractBomGenerator;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;

public class BomGeneratorFactory {
    public static AbstractBomGenerator create(Version version, Bom bom, Format format) {
        AbstractBomGenerator generator;
        switch (format) {
            case XML: {
                generator = BomGeneratorFactory.createXml(version, bom);
                break;
            }
            case JSON: {
                generator = BomGeneratorFactory.createJson(version, bom);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format " + (Object)((Object)format));
            }
        }
        return generator;
    }

    public static BomXmlGenerator createXml(Version version, Bom bom) {
        return new BomXmlGenerator(bom, version);
    }

    public static BomJsonGenerator createJson(Version version, Bom bom) {
        return new BomJsonGenerator(bom, version);
    }
}

