/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.sonar.report.pdf.entity.Measure;
import org.sonar.report.pdf.util.Logger;
import org.sonar.report.pdf.util.SonarAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measures {
    private static final String MEASURES = "//resources/resource/msr";
    private static final String DATE = "//resources/resource/date";
    private static final String VERSION = "//resources/resource/version";
    private static List<String> measuresKeys = null;
    private Hashtable<String, Measure> measuresTable = new Hashtable();
    private Date date;
    private String version = "N/A";
    private static Integer DEFAULT_SPLIT_LIMIT = 20;

    public void initMeasuresByProjectKey(SonarAccess sonarAccess, String projectKey) throws HttpException, IOException, DocumentException {
        if (measuresKeys == null) {
            measuresKeys = this.getAllMetricKeys(sonarAccess);
        }
        if (measuresKeys.size() > DEFAULT_SPLIT_LIMIT) {
            this.initMeasuresSplittingRequests(sonarAccess, projectKey);
        } else {
            String keys = measuresKeys.toString();
            keys = keys.substring(1, keys.length() - 1);
            this.addMeasures(keys, sonarAccess, projectKey);
        }
    }

    public List<String> getAllMetricKeys(SonarAccess sonarAccess) throws HttpException, IOException, DocumentException {
        String urlAllMetrics = "/api/metrics?format=xml";
        Logger.debug("Accessing Sonar: getting all metric keys");
        Document allMetricsDocument = sonarAccess.getUrlAsDocument(urlAllMetrics);
        List allMetricKeysNodes = allMetricsDocument.selectNodes("//metrics/metric/key");
        ArrayList<String> allMetricKeys = new ArrayList<String>();
        Iterator it = allMetricKeysNodes.iterator();
        while (it.hasNext()) {
            allMetricKeys.add(((Node)it.next()).getText());
        }
        return allMetricKeys;
    }

    private void initMeasuresSplittingRequests(SonarAccess sonarAccess, String projectKey) throws HttpException, IOException, DocumentException {
        Iterator<String> it = measuresKeys.iterator();
        Logger.debug("Getting " + measuresKeys.size() + " metric measures from Sonar by splitting requests");
        String twentyMeasures = "";
        int i = 0;
        boolean isTheFirst = true;
        while (it.hasNext()) {
            if (isTheFirst) {
                twentyMeasures = twentyMeasures + it.next();
                isTheFirst = false;
            } else {
                twentyMeasures = twentyMeasures + "," + it.next();
            }
            if (++i % DEFAULT_SPLIT_LIMIT != 0) continue;
            Logger.debug("Split request for: " + twentyMeasures);
            this.addMeasures(twentyMeasures, sonarAccess, projectKey);
            i = 0;
            isTheFirst = true;
            twentyMeasures = "";
        }
        if (i != 0) {
            Logger.debug("Split request for remain metric measures: " + twentyMeasures);
            this.addMeasures(twentyMeasures, sonarAccess, projectKey);
        }
    }

    private void addMeasures(String measuresAsString, SonarAccess sonarAccess, String projectKey) throws HttpException, IOException, DocumentException {
        String urlAllMesaures = "/api/resources?resource=" + projectKey + "&depth=0&format=xml&includetrends=true" + "&metrics=" + measuresAsString;
        this.addAllMeasuresFromDocument(sonarAccess.getUrlAsDocument(urlAllMesaures));
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(String date) throws ParseException {
        if (date.equals("now")) {
            this.date = new Date();
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.date = df.parse(date);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getMeasuresCount() {
        return this.measuresTable.size();
    }

    public Set<String> getMeasuresKeys() {
        return this.measuresTable.keySet();
    }

    public Measure getMeasure(String key) {
        return this.measuresTable.get(key);
    }

    public void addMeasure(String name, Measure value) {
        this.measuresTable.put(name, value);
    }

    public boolean containsMeasure(String measureKey) {
        return this.measuresTable.containsKey(measureKey);
    }

    public void addMesaureFromNode(Node measureNode) {
        Measure measure = new Measure();
        measure.initFromNode(measureNode);
        this.measuresTable.put(measure.getKey(), measure);
    }

    public void addAllMeasuresFromDocument(Document allMeasuresNode) {
        List allNodes = allMeasuresNode.selectNodes(MEASURES);
        Iterator it = allNodes.iterator();
        while (it.hasNext()) {
            this.addMesaureFromNode((Node)it.next());
        }
        try {
            this.setDate(allMeasuresNode.selectSingleNode(DATE).getText());
            this.setVersion(allMeasuresNode.selectSingleNode(VERSION).getText());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

