/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.AbstractBaseJnlpMojo;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.JnlpFile;
import org.codehaus.mojo.webstart.generator.JarResourcesGenerator;
import org.codehaus.mojo.webstart.generator.SimpleGeneratorExtraConfig;
import org.codehaus.mojo.webstart.generator.VersionXmlGenerator;
import org.codehaus.mojo.webstart.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="jnlp-download-servlet", requiresProject=true, inheritByDefault=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JnlpDownloadServletMojo
extends AbstractBaseJnlpMojo {
    @Parameter(defaultValue="webstart")
    private String outputDirectoryName;
    @Parameter(required=true)
    private List<JnlpFile> jnlpFiles;
    @Parameter
    private List<JarResource> commonJarResources;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private MavenProject project;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        IOUtil ioUtil = this.getIoUtil();
        ioUtil.copyResources(this.getResourcesDirectory(), this.getWorkDirectory());
        if (this.commonJarResources != null) {
            this.retrieveJarResources(this.commonJarResources);
        }
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            this.retrieveJarResources(jnlpFile.getJarResources());
        }
        this.signOrRenameJars();
        this.packJars();
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            this.generateJnlpFile(jnlpFile, this.getLibPath());
        }
        this.generateVersionXml();
        File outputDir = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + File.separator + this.outputDirectoryName);
        ioUtil.makeDirectoryIfNecessary(outputDir);
        ioUtil.copyDirectoryStructure(this.getWorkDirectory(), outputDir);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    private void checkConfiguration() throws MojoExecutionException {
        if (this.jnlpFiles.isEmpty()) {
            throw new MojoExecutionException("Configuration error: At least one <jnlpFile> element must be specified");
        }
        if (this.jnlpFiles.size() == 1 && StringUtils.isEmpty((String)this.jnlpFiles.get(0).getOutputFilename())) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified in single set of jnlpFiles. Using default output file name: launch.jnlp.");
            this.jnlpFiles.get(0).setOutputFilename("launch.jnlp");
        }
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            this.checkJnlpFileConfiguration(jnlpFile);
        }
        this.checkForDuplicateJarResources();
        this.checkCommonJarResources();
        this.checkForUniqueJnlpFilenames();
        this.checkPack200();
    }

    private void checkJnlpFileConfiguration(JnlpFile jnlpFile) throws MojoExecutionException {
        if (StringUtils.isBlank((String)jnlpFile.getOutputFilename())) {
            throw new MojoExecutionException("Configuration error: An outputFilename must be specified for each jnlpFile element");
        }
        if (StringUtils.isBlank((String)jnlpFile.getTemplateFilename())) {
            this.getLog().info((CharSequence)("No templateFilename found for " + jnlpFile.getOutputFilename() + ". Will use the default template."));
        } else {
            File templateFile = new File(this.getTemplateDirectory(), jnlpFile.getTemplateFilename());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP template does not exist: [" + templateFile + "]");
            }
        }
        this.checkJnlpJarResources(jnlpFile);
    }

    private void checkJnlpJarResources(JnlpFile jnlpFile) throws MojoExecutionException {
        List<JarResource> jnlpJarResources = jnlpFile.getJarResources();
        if (jnlpJarResources == null || jnlpJarResources.isEmpty()) {
            throw new MojoExecutionException("Configuration error: A non-empty <jarResources> element must be specified in the plugin configuration for the JNLP file named [" + jnlpFile.getOutputFilename() + "]");
        }
        ArrayList<JarResource> jarsWithMainClass = new ArrayList<JarResource>();
        for (JarResource jarResource : jnlpJarResources) {
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() == null) continue;
            jnlpFile.setMainClass(jarResource.getMainClass());
            jarsWithMainClass.add(jarResource);
        }
        if (jarsWithMainClass.isEmpty()) {
            throw new MojoExecutionException("Configuration error: Exactly one <jarResource> element must be declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
        if (jarsWithMainClass.size() > 1) {
            throw new MojoExecutionException("Configuration error: More than one <jarResource> element has been declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
    }

    private void checkForDuplicateJarResources() throws MojoExecutionException {
        if (this.commonJarResources == null || this.commonJarResources.isEmpty()) {
            return;
        }
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            List<JarResource> jnlpJarResources = jnlpFile.getJarResources();
            for (JarResource jarResource : jnlpJarResources) {
                if (!this.commonJarResources.contains(jarResource)) continue;
                String message = "Configuration Error: The jar resource element for artifact " + jarResource + " defined in common jar resources is duplicated in the jar " + "resources configuration of the jnlp file identified by the template file " + jnlpFile.getTemplateFilename() + ".";
                throw new MojoExecutionException(message);
            }
        }
    }

    private void checkCommonJarResources() throws MojoExecutionException {
        if (this.commonJarResources == null) {
            return;
        }
        for (JarResource jarResource : this.commonJarResources) {
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() == null) continue;
            throw new MojoExecutionException("Configuration Error: A mainClass must not be specified on a JarResource in the commonJarResources collection.");
        }
    }

    private void checkMandatoryJarResourceFields(JarResource jarResource) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)jarResource.getGroupId()) || StringUtils.isEmpty((String)jarResource.getArtifactId()) || StringUtils.isEmpty((String)jarResource.getVersion())) {
            throw new MojoExecutionException("Configuration error: groupId, artifactId or version missing for jarResource[" + jarResource + "].");
        }
    }

    private void checkForUniqueJnlpFilenames() throws MojoExecutionException {
        HashSet<String> filenames = new HashSet<String>(this.jnlpFiles.size());
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            if (filenames.add(jnlpFile.getOutputFilename())) continue;
            throw new MojoExecutionException("Configuration error: Unique JNLP filenames must be provided. The following file name appears more than once [" + jnlpFile.getOutputFilename() + "].");
        }
    }

    private void retrieveJarResources(List<JarResource> jarResources) throws MojoExecutionException {
        HashSet<JarResource> extraJarResources = new HashSet<JarResource>();
        try {
            Artifact artifact;
            for (JarResource jarResource : jarResources) {
                artifact = this.createArtifact(jarResource);
                jarResource.setArtifact(artifact);
                extraJarResources.addAll(this.retrieveAdditionalJarResources(jarResource));
                this.checkForMainClass(jarResource);
            }
            jarResources.addAll(extraJarResources);
            for (JarResource jarResource : jarResources) {
                artifact = jarResource.getArtifact();
                boolean copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(artifact.getFile(), this.getLibDirectory());
                if (copied) {
                    String name = artifact.getFile().getName();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Adding " + name + " to modifiedJnlpArtifacts list."));
                    }
                    this.verboseLog("Adding " + name + " to modifiedJnlpArtifacts list.");
                    this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
                }
                if (!jarResource.isOutputJarVersion()) continue;
                String hrefValue = this.buildHrefValue(artifact);
                jarResource.setHrefValue(hrefValue);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve an artifact", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find an artifact", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy an artifact to the working directory", (Exception)e);
        }
    }

    private Artifact createArtifact(JarResource jarResource) {
        if (jarResource.getClassifier() == null) {
            return this.getArtifactFactory().createArtifact(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "runtime", "jar");
        }
        return this.getArtifactFactory().createArtifactWithClassifier(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "jar", jarResource.getClassifier());
    }

    private void checkForMainClass(JarResource jarResource) throws MojoExecutionException {
        String mainClass = jarResource.getMainClass();
        if (mainClass == null) {
            return;
        }
        Artifact artifact = jarResource.getArtifact();
        if (artifact == null) {
            throw new IllegalStateException("Implementation Error: The given jarResource cannot be checked for a main class until the underlying artifact has been resolved: [" + jarResource + "]");
        }
        try {
            boolean containsMainClass = this.getArtifactUtil().artifactContainsMainClass(artifact, jarResource);
            if (!containsMainClass) {
                throw new MojoExecutionException("The jar specified by the following jarResource does not contain the declared main class:" + jarResource);
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Attempting to find main class [" + mainClass + "] in [" + artifact + "]", (Exception)e);
        }
    }

    private Set<JarResource> retrieveAdditionalJarResources(JarResource jarResource) throws ArtifactResolutionException, ArtifactNotFoundException {
        HashSet<JarResource> result = new HashSet<JarResource>();
        Artifact artifact = jarResource.getArtifact();
        for (MavenProject mp : this.reactorProjects) {
            Artifact resolvedArtifact = null;
            if (mp.getArtifact().equals(artifact)) {
                resolvedArtifact = mp.getArtifact();
            } else {
                for (Object o : mp.getAttachedArtifacts()) {
                    Artifact candidate = (Artifact)o;
                    if (!candidate.equals(artifact)) continue;
                    resolvedArtifact = mp.getArtifact();
                    break;
                }
            }
            if (resolvedArtifact == null) continue;
            this.verboseLog("Jar resource " + jarResource + " found from reactor " + mp);
            jarResource.setArtifact(resolvedArtifact);
            if (!this.isExcludeTransitive()) {
                for (Object o : mp.getArtifacts()) {
                    Artifact artifact1 = (Artifact)o;
                    if ("pom".equals(artifact1.getType())) continue;
                    JarResource resource = new JarResource(artifact1);
                    resource.setOutputJarVersion(true);
                    result.add(resource);
                }
            }
            return result;
        }
        this.getArtifactResolver().resolve(artifact, this.getRemoteRepositories(), this.getLocalRepository());
        if (!this.isExcludeTransitive()) {
            ArtifactResolutionResult arr = this.getArtifactResolver().resolveTransitively(Collections.singleton(artifact), artifact, null, this.getLocalRepository(), this.getRemoteRepositories(), this.artifactMetadataSource, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
            for (Object o : arr.getArtifactResolutionNodes()) {
                JarResource newJarResource = new JarResource((Artifact)o);
                newJarResource.setOutputJarVersion(true);
                result.add(newJarResource);
            }
        }
        return result;
    }

    private void generateJnlpFile(JnlpFile jnlpFile, String libPath) throws MojoExecutionException {
        File jnlpOutputFile = new File(this.getWorkDirectory(), jnlpFile.getOutputFilename());
        LinkedHashSet<JarResource> jarResources = new LinkedHashSet<JarResource>();
        jarResources.addAll(jnlpFile.getJarResources());
        if (this.commonJarResources != null && !this.commonJarResources.isEmpty()) {
            for (JarResource jarResource : this.commonJarResources) {
                jarResources.add(jarResource);
            }
            jarResources.addAll(this.commonJarResources);
        }
        JarResourcesGenerator jnlpGenerator = new JarResourcesGenerator(this.getLog(), this.getProject(), this.getTemplateDirectory(), "default-jnlp-servlet-template.vm", jnlpOutputFile, jnlpFile.getTemplateFilename(), jarResources, jnlpFile.getMainClass(), this.getWebstartJarURLForVelocity(), libPath, this.getEncoding());
        jnlpGenerator.setExtraConfig(new SimpleGeneratorExtraConfig(this.getCodebase()));
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("The following error occurred attempting to generate the JNLP deployment descriptor: " + e, e);
        }
    }

    private void generateVersionXml() throws MojoExecutionException {
        LinkedHashSet<JarResource> jarResources = new LinkedHashSet<JarResource>();
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            jarResources.addAll(jnlpFile.getJarResources());
        }
        if (this.commonJarResources != null) {
            jarResources.addAll(this.commonJarResources);
        }
        VersionXmlGenerator generator = new VersionXmlGenerator(this.getEncoding());
        generator.generate(this.getLibDirectory(), jarResources);
    }

    private String buildHrefValue(Artifact artifact) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(artifact.getArtifactId());
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            sbuf.append("-").append(artifact.getClassifier());
        }
        sbuf.append(".").append(artifact.getArtifactHandler().getExtension());
        return sbuf.toString();
    }
}

