/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.codehaus.mojo.weblogic.DeployMojoBase;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.ant.taskdefs.management.WLDeploy;

public class DeployMojo
extends DeployMojoBase {
    public void execute() throws MojoExecutionException {
        File targetSource;
        super.execute();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic Deployment beginning with parameters " + this.toString()));
        }
        try {
            targetSource = new File(this.getArtifactPath());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        try {
            WLDeploy deployer = new WLDeploy();
            Project project = new Project();
            project.setName("deploy");
            project.addBuildListener(this.getDefaultLogger());
            project.setSystemProperties();
            deployer.setProject(project);
            deployer.setRemote(this.isRemote());
            deployer.setVerbose(this.isVerbose());
            deployer.setAdminUrl(WeblogicMojoUtilities.getAdminUrl(this.getAdminServerProtocol(), this.getAdminServerHostName(), this.getAdminServerPort()));
            deployer.setNoStage(this.isStage());
            deployer.setUser(this.getUserId());
            deployer.setPassword(this.getPassword());
            deployer.setName(this.getName());
            deployer.setTargets(this.getTargetNames());
            deployer.setSource(targetSource);
            deployer.setAction("deploy");
            deployer.setDebug(this.isDebug());
            deployer.setEnableSecurityValidation(true);
            deployer.setUpload(this.isUpload());
            deployer.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during deployment ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during deployment", ex);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic Deployment successful ");
        }
    }
}

