/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.ant.taskdefs.webservices.wsdlgen.WSDLGen;

public class WsdlGenMojo
extends AbstractWeblogicMojo {
    private String serviceName;
    private String warName;
    private String wsdlFile;
    private String defaultEndpoint;
    private String earFileName;
    private boolean overwrite;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Weblogic wsdl gen beginning ");
        }
        File earFile = this.earFileName == null ? WeblogicMojoUtilities.getEarFileName(this.getArtifacts()) : new File(this.earFileName);
        String classPath = WeblogicMojoUtilities.getDependencies(this.getArtifacts());
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic wsdl gen for ear " + earFile));
        }
        try {
            WSDLGen wsdl = new WSDLGen();
            Project antProject = new Project();
            antProject.setName("wsdlgen");
            wsdl.setProject(antProject);
            wsdl.setClasspath(new Path(antProject, classPath));
            wsdl.setEar(earFile);
            wsdl.setWarName(this.warName);
            File wsdlFileFile = new File(this.wsdlFile);
            wsdl.setWsdlFile(wsdlFileFile);
            wsdl.setServiceName(this.serviceName);
            wsdl.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during WSDLGen processing ", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during WSDLGen processing", ex);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getEarFileName() {
        return this.earFileName;
    }

    public void setEarFileName(String earFileName) {
        this.earFileName = earFileName;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientGenMojo[");
        buffer.append("earFileName = ").append(this.earFileName);
        buffer.append(", warName = ").append(this.warName);
        buffer.append(", serviceName = ").append(this.serviceName);
        buffer.append(", overwrite = ").append(this.overwrite);
        buffer.append("]");
        return buffer.toString();
    }
}

