/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.wsee.tools.anttasks.JwsFileSet;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.anttasks.JwscTask;
import weblogic.wsee.tools.anttasks.MultipleJwsModule;

public class JwscMojo
extends AbstractWeblogicMojo {
    private String outputDir;
    private String inputDir;
    private String outputName;
    private boolean verbose;
    private boolean debug;
    private boolean explode;
    private boolean optimize;
    private String contextPath;
    private String descriptor;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Weblogic jwsc beginning for output " + this.outputName));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("inputDir=" + this.inputDir + "  contextPath=" + this.contextPath));
        }
        if (this.contextPath == null) {
            this.getLog().warn((CharSequence)"Context path is null. It will be required if more than one web service is present.");
        }
        try {
            Iterator iter = this.getDependencies().iterator();
            while (iter.hasNext()) {
                this.getLog().debug((CharSequence)iter.next().toString());
            }
            JwscTask task = new JwscTask();
            Project project = new Project();
            project.addBuildListener(this.getDefaultLogger());
            project.setName("jwsc");
            Path path = new Path(project, WeblogicMojoUtilities.getDependencies(this.getArtifacts(), this.getPluginArtifacts()));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Path=" + path.toString()));
            }
            task.setProject(project);
            task.setTaskName(project.getName());
            task.setNowarn(false);
            task.setClasspath(path);
            task.setDestdir(new File(this.outputDir));
            task.setVerbose(this.verbose);
            task.setOptimize(this.optimize);
            task.setDebug(this.debug);
            task.setSrcdir(new File(this.inputDir));
            MultipleJwsModule module = task.createModule();
            JwsFileSet jwsFileSet = module.createJwsFileSet();
            jwsFileSet.setProject(project);
            jwsFileSet.setSrcdir(new Path(project, this.inputDir));
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("fileset=" + jwsFileSet.getSrcdir().toString()));
            }
            if (this.descriptor != null) {
                JwsModule.Descriptor descriptor = module.createDescriptor();
                descriptor.setFile(new File(this.descriptor));
            }
            module.setName(this.outputName);
            module.setExplode(this.explode);
            module.setContextPath(this.contextPath);
            task.execute();
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"Exception encountered during jwsc", (Throwable)ex);
            throw new MojoExecutionException("Exception encountered during jwsc", ex);
        }
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isExplode() {
        return this.explode;
    }

    public void setExplode(boolean explode) {
        this.explode = explode;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String toString() {
        return "JwscMojo{outputDir='" + this.outputDir + '\'' + ", inputDir='" + this.inputDir + '\'' + ", outputName='" + this.outputName + '\'' + ", verbose=" + this.verbose + ", debug=" + this.debug + ", explode=" + this.explode + ", optimize=" + this.optimize + ", contextPath='" + this.contextPath + '\'' + ", descriptor='" + this.descriptor + '\'' + '}';
    }
}

