/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.AbstractWagonMojo;

public abstract class AbstractSingleWagonMojo
extends AbstractWagonMojo {
    private String url;
    private String serverId;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution.");
            return;
        }
        Wagon wagon = null;
        try {
            wagon = this.createWagon(this.serverId, this.url);
            this.execute(wagon);
        }
        catch (WagonException e) {
            throw new MojoExecutionException("Error handling resource", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error handling resource", (Exception)e);
        }
        finally {
            try {
                if (wagon != null) {
                    wagon.disconnect();
                }
            }
            catch (ConnectionException e) {
                this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    protected abstract void execute(Wagon var1) throws MojoExecutionException, WagonException, IOException;
}

