/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RuleServiceUtils;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyBuilder;

public class DependencyUpdatesLoggingHelper {
    private final RuleService ruleService;
    private final Optional<Segment> unchangedSegment;
    private final boolean allowSnapshots;
    private final int maxLineWidth;
    private final boolean displayManagedBy;
    private final MavenProject project;
    private final ArtifactFactory artifactFactory;
    private final Log log;

    public DependencyUpdatesLoggingHelper(MavenProject project, Log log, ArtifactFactory artifactFactory, RuleService ruleService, Optional<Segment> unchangedSegment, boolean allowSnapshots, int maxLineWidth, boolean displayManagedBy) {
        this.project = project;
        this.log = log;
        this.artifactFactory = artifactFactory;
        this.ruleService = ruleService;
        this.unchangedSegment = unchangedSegment;
        this.allowSnapshots = allowSnapshots;
        this.maxLineWidth = maxLineWidth;
        this.displayManagedBy = displayManagedBy;
    }

    private boolean dependencyVersionLocalToProject(Dependency dependency) {
        return dependency.getLocation((Object)DependencyBuilder.Location.VERSION.toString()).getSource().getModelId().equals(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
    }

    public DependencyUpdatesResult getDependencyUpdates(Map<Dependency, ArtifactVersions> updates) {
        final ArrayList<String> withUpdates = new ArrayList<String>();
        final ArrayList usingCurrent = new ArrayList();
        for (Map.Entry<Dependency, ArtifactVersions> entry : updates.entrySet()) {
            ArrayList<String> t;
            Optional<ArtifactVersion> latestVersion;
            String currentVersion;
            Dependency dep = entry.getKey();
            ArtifactVersions versions = RuleServiceUtils.filterByRuleService((String)dep.getGroupId(), (String)dep.getArtifactId(), (ArtifactVersions)entry.getValue(), (RuleService)this.ruleService, (Log)this.log);
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.getCurrentVersion() != null) {
                currentVersion = versions.getCurrentVersion() + (!this.displayManagedBy || this.dependencyVersionLocalToProject(dep) ? "" : " (managed by " + dep.getLocation((Object)DependencyBuilder.Location.VERSION.toString()).getSource().getModelId() + ")");
                try {
                    latestVersion = versions.getNewestVersion(currentVersion, this.unchangedSegment, this.allowSnapshots, false);
                }
                catch (InvalidSegmentException e) {
                    latestVersion = Optional.empty();
                }
            } else {
                Restriction newVersionRestriction;
                currentVersion = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion actualVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), this.allowSnapshots);
                try {
                    Restriction segmentRestriction = versions.restrictionForUnchangedSegment(actualVersion, this.unchangedSegment, false);
                    newVersionRestriction = new Restriction(actualVersion, false, segmentRestriction.getUpperBound(), segmentRestriction.isUpperBoundInclusive());
                }
                catch (InvalidSegmentException e) {
                    throw new RuntimeException(e);
                }
                latestVersion = Optional.of(newVersionRestriction).map(restriction -> versions.getNewestVersion(restriction, this.allowSnapshots));
            }
            String right = " " + latestVersion.map(v -> currentVersion + " -> " + v).orElse(currentVersion);
            ArrayList<String> arrayList = t = latestVersion.isPresent() ? withUpdates : usingCurrent;
            if (right.length() + left.length() + 3 > this.maxLineWidth) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)this.maxLineWidth));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(this.maxLineWidth - right.length()), (String)".") + right);
        }
        return new DependencyUpdatesResult(){
            final /* synthetic */ DependencyUpdatesLoggingHelper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public List<String> getUsingLatest() {
                return usingCurrent;
            }

            @Override
            public List<String> getWithUpdates() {
                return withUpdates;
            }
        };
    }

    public static interface DependencyUpdatesResult {
        public List<String> getUsingLatest();

        public List<String> getWithUpdates();
    }
}

