/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="use-reactor", threadSafe=true)
public class UseReactorMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Inject
    public UseReactorMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingParent() && this.getProject().hasParent()) {
                this.useReactor(pom, this.getProject().getParent());
            }
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useReactor(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReactor(pom, this.getProject().getDependencies());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useReactor(MutableXMLStreamReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        block0: for (Dependency dep : dependencies) {
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            for (MavenProject reactorProject : this.reactorProjects) {
                if (!StringUtils.equals((CharSequence)reactorProject.getGroupId(), (CharSequence)dep.getGroupId()) || !StringUtils.equals((CharSequence)reactorProject.getArtifactId(), (CharSequence)dep.getArtifactId()) || StringUtils.equals((CharSequence)reactorProject.getVersion(), (CharSequence)dep.getVersion())) continue;
                if (!PomHelper.setDependencyVersion((MutableXMLStreamReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion(), (String)reactorProject.getVersion(), (Model)this.getProject().getModel(), (Log)this.getLog())) continue block0;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + reactorProject.getVersion()));
                continue block0;
            }
        }
    }

    private void useReactor(MutableXMLStreamReader pom, MavenProject parent) throws XMLStreamException, VersionRetrievalException {
        for (MavenProject project : this.reactorProjects) {
            if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)parent.getGroupId()) || !StringUtils.equals((CharSequence)project.getArtifactId(), (CharSequence)parent.getArtifactId()) || StringUtils.equals((CharSequence)project.getVersion(), (CharSequence)parent.getVersion()) || !PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)project.getVersion())) continue;
            this.getLog().info((CharSequence)("Updated parent " + this.toString(parent) + " to version " + project.getVersion()));
        }
    }
}

