/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.reporting.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.plexus.i18n.I18N;

public class PropertyUpdatesReportRenderer
extends AbstractVersionsReportRenderer<PropertyUpdatesModel> {
    public PropertyUpdatesReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, PropertyUpdatesModel model, boolean allowSnapshots) {
        super(i18n, sink, locale, bundleName, model, allowSnapshots);
    }

    @Override
    protected void renderManagementSummaryTable() {
    }

    @Override
    protected void renderSummaryTable() {
        this.renderTable("report.overview.property", ((PropertyUpdatesModel)this.model).getAllUpdates(), "report.overview.noProperty");
    }

    @Override
    protected void renderDetails() {
        ((PropertyUpdatesModel)this.model).getAllUpdates().forEach(this::renderPropertyDetail);
    }

    protected void renderTable(String titleKey, Map<Property, PropertyVersions> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderSummaryTable(contents);
        }
        this.sink.section2_();
    }

    protected void renderSummaryTable(Map<Property, PropertyVersions> contents) {
        this.sink.table();
        this.sink.tableRows(null, false);
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        contents.forEach(this::renderPropertySummaryTableRow);
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.table_();
    }

    private void renderPropertySummaryTableRow(Property property, PropertyVersions details) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get((AbstractVersionDetails)details, Optional.empty(), this.isAllowSnapshots());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.tableRow();
        this.sink.tableCell();
        this.renderIcon(upToDate);
        this.sink.tableCell_();
        this.renderCells("${" + property.getName() + "}", details.getCurrentVersion());
        this.renderNewestVersions((AbstractVersionDetails)details);
        this.sink.tableRow_();
    }

    protected void renderPropertyDetailTable(Property property, PropertyVersions details) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get((AbstractVersionDetails)details, Optional.empty(), this.isAllowSnapshots());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.renderTwoCellsRow("report.status", () -> this.renderStatus((AbstractVersionDetails)details));
        this.renderTwoCellsRow("report.property", "${" + property.getName() + "}");
        this.renderTwoCellsRow("report.associations", () -> this.renderAssociations(details));
        this.renderTwoCellsRow("report.currentVersion", details.getCurrentVersion().toString());
        if (!upToDate) {
            this.renderTwoCellsRow("report.updateVersions", () -> this.renderVersions(allUpdates, (AbstractVersionDetails)details));
        }
        this.renderTwoCellsRow("report.versionRange", details.getCurrentVersion().toString());
        this.renderTwoCellsRow("report.autoLinkDependencies", property.isAutoLinkDependencies());
        this.renderTwoCellsRow("report.banSnapshots", property.isBanSnapshots());
        this.renderTwoCellsRow("report.searchReactor", property.isSearchReactor());
        this.renderTwoCellsRow("report.preferReactor", property.isPreferReactor());
        this.sink.tableRows_();
        this.sink.table_();
    }

    private void renderTwoCellsRow(String textKey, boolean b) {
        this.renderTwoCellsRow(textKey, this.getText(b ? "report.yes" : "report.no"));
    }

    private void renderAssociations(PropertyVersions details) {
        ArtifactAssociation[] associations = details.getAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (i > 0) {
                this.sink.lineBreak();
            }
            this.sink.text(ArtifactUtils.versionlessKey((Artifact)associations[i].getArtifact()));
        }
    }

    @Override
    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        this.renderTableHeaderCells("report.status", "report.property", "report.currentVersion", "report.latestSubIncremental", "report.latestIncremental", "report.latestMinor", "report.latestMajor");
    }

    @Override
    protected OverviewStats computeOverviewStats() {
        return OverviewStats.fromUpdates(((PropertyUpdatesModel)this.model).getAllUpdates().values(), this.newestUpdateCache, this.isAllowSnapshots());
    }

    private void renderPropertyDetail(Property property, PropertyVersions details) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text("${" + property.getName() + "}");
        this.sink.sectionTitle2_();
        this.renderPropertyDetailTable(property, details);
        this.sink.section2_();
    }
}

